/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.text.StringEscapeUtils;
import uk.modl.interpreter.Interpreter;
import uk.modl.interpreter.VariableMethods;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

class StringTransformer {
    private Map<String, ModlValue> valuePairs;
    private Map<String, ModlValue> variables;
    private Map<Integer, ModlValue> numberedVariables;

    StringTransformer(Map<String, ModlValue> valuePairs, Map<String, ModlValue> variables, Map<Integer, ModlValue> numberedVariables) {
        this.valuePairs = valuePairs;
        this.variables = variables;
        this.numberedVariables = numberedVariables;
    }

    public static List<String> getPercentPartsFromString(String stringToTransform) {
        LinkedList<String> percentParts = new LinkedList<String>();
        int currentIndex = 0;
        boolean finished = false;
        while (!finished) {
            Integer endIndex;
            finished = true;
            Integer startIndex = StringTransformer.getNextPercent(stringToTransform, currentIndex);
            if (startIndex == null) continue;
            if (startIndex < stringToTransform.length() - 1 && !StringTransformer.isNumber(stringToTransform.substring(startIndex + 1, startIndex + 2))) {
                int spaceEndIndex = stringToTransform.indexOf(" ", (int)startIndex);
                int colonEndIndex = stringToTransform.indexOf(":", (int)startIndex);
                if (spaceEndIndex == -1) {
                    spaceEndIndex = 99999;
                }
                if (colonEndIndex == -1) {
                    colonEndIndex = 99999;
                }
                if ((endIndex = Integer.valueOf(Math.min(spaceEndIndex, colonEndIndex))) > stringToTransform.length()) {
                    endIndex = stringToTransform.length();
                }
            } else {
                if (startIndex == stringToTransform.length() - 1) {
                    return percentParts;
                }
                endIndex = StringTransformer.getEndOfNumber(stringToTransform, startIndex + 1);
            }
            if (endIndex == null || endIndex == -1) continue;
            if (endIndex > startIndex + 1) {
                String gravePart = stringToTransform.substring(startIndex, endIndex);
                if (gravePart.endsWith("%")) {
                    gravePart = gravePart.substring(0, gravePart.length() - 1);
                }
                percentParts.add(gravePart);
                currentIndex = endIndex + 1;
            }
            finished = false;
        }
        return percentParts;
    }

    private static Integer getEndOfNumber(String stringToTransform, Integer startIndex) {
        char nextChar;
        Integer n;
        Integer currentIndex = startIndex;
        if (currentIndex.intValue() == stringToTransform.length()) {
            return currentIndex;
        }
        while (StringTransformer.isNumber(stringToTransform.substring(currentIndex, currentIndex + 1))) {
            Integer n2 = currentIndex;
            n = currentIndex = Integer.valueOf(currentIndex + 1);
            if (currentIndex.intValue() != stringToTransform.length()) continue;
            return currentIndex;
        }
        if (!stringToTransform.substring(currentIndex, currentIndex + 1).equals(".")) {
            return currentIndex;
        }
        do {
            Integer n3 = currentIndex;
            n = currentIndex = Integer.valueOf(currentIndex + 1);
            if (currentIndex <= stringToTransform.length() - 1) continue;
            return currentIndex;
        } while ((nextChar = stringToTransform.charAt(currentIndex)) == '.' || Character.isLetterOrDigit(nextChar));
        return currentIndex;
    }

    private static boolean isNumber(String substring) {
        return substring.equals("0") || substring.equals("1") || substring.equals("2") || substring.equals("3") || substring.equals("4") || substring.equals("5") || substring.equals("6") || substring.equals("7") || substring.equals("8") || substring.equals("9");
    }

    private static Integer getNextPercent(String stringToTransform, Integer startIndex) {
        int index = stringToTransform.indexOf("%", (int)startIndex);
        if (index == -1) {
            return null;
        }
        return index;
    }

    ModlValue transformString(String stringToTransform) {
        String number;
        ModlValue ret;
        if (stringToTransform == null) {
            return null;
        }
        stringToTransform = StringEscapeUtils.unescapeJava((String)stringToTransform);
        List<String> graveParts = this.getGravePartsFromString(stringToTransform);
        for (String gravePart : graveParts) {
            if (gravePart.startsWith("`%")) {
                ret = this.runObjectReferencing(gravePart, stringToTransform, true);
                if (ret instanceof ModlObject.String) {
                    stringToTransform = ((ModlObject.String)ret).string;
                    String nonGravePart = gravePart.substring(1, gravePart.length() - 1);
                    stringToTransform = stringToTransform.replace(gravePart, nonGravePart);
                    continue;
                }
                if (ret instanceof ModlObject.Number) {
                    if (gravePart.equals(stringToTransform)) {
                        return ret;
                    }
                    number = ((ModlObject.Number)ret).number;
                    stringToTransform = stringToTransform.replace(gravePart, number);
                    continue;
                }
                return ret;
            }
            String newGravePart = gravePart.substring(1, gravePart.length() - 1);
            int dotIndex = (stringToTransform = stringToTransform.replace(gravePart, newGravePart)).indexOf(46);
            if (dotIndex <= -1) continue;
            String firstPart = stringToTransform.substring(0, dotIndex);
            String methods = stringToTransform.substring(dotIndex + 1);
            stringToTransform = this.runMethods(firstPart, methods);
        }
        List<String> percentParts = StringTransformer.getPercentPartsFromString(stringToTransform);
        for (String percentPart : percentParts) {
            ret = this.runObjectReferencing(percentPart, stringToTransform, false);
            if (ret instanceof ModlObject.String) {
                ModlObject.String theString = (ModlObject.String)ret;
                if (stringToTransform.equals(theString.string) && !stringToTransform.startsWith("%*") && stringToTransform.contains(".") && stringToTransform.contains("%") && stringToTransform.indexOf("%") == stringToTransform.lastIndexOf("%")) {
                    throw new RuntimeException("Interpreter Error: Cannot resolve reference in: \"" + stringToTransform + "\"");
                }
                stringToTransform = theString.string;
                continue;
            }
            if (ret instanceof ModlObject.Number) {
                if (percentPart.equals(stringToTransform)) {
                    return ret;
                }
                number = ((ModlObject.Number)ret).number;
                stringToTransform = stringToTransform.replace(percentPart, number);
                continue;
            }
            return ret;
        }
        return new ModlObject.String(stringToTransform);
    }

    private List<String> getGravePartsFromString(String stringToTransform) {
        LinkedList<String> graveParts = new LinkedList<String>();
        int currentIndex = 0;
        boolean finished = false;
        while (!finished) {
            Integer endIndex;
            finished = true;
            Integer startIndex = this.getNextNonPrefixedGrave(stringToTransform, currentIndex);
            if (startIndex == null || (endIndex = this.getNextNonPrefixedGrave(stringToTransform, startIndex + 1)) == null) continue;
            String gravePart = stringToTransform.substring(startIndex, endIndex + 1);
            graveParts.add(gravePart);
            currentIndex = endIndex + 1;
            finished = false;
        }
        return graveParts;
    }

    private Integer getNextNonPrefixedGrave(String stringToTransform, Integer startIndex) {
        int index = stringToTransform.indexOf("`", (int)startIndex);
        if (index == -1) {
            return null;
        }
        if (index > startIndex) {
            String prefix = stringToTransform.substring(index - 1, index);
            if (prefix.equals("~") || prefix.equals("\\")) {
                return this.getNextNonPrefixedGrave(stringToTransform, index + 1);
            }
            return index;
        }
        return startIndex;
    }

    ModlValue runObjectReferencing(String percentPart, String stringToTransform, boolean isGraved) {
        int startOffset = 1;
        int endOffset = 0;
        if (isGraved) {
            ++startOffset;
            ++endOffset;
        }
        String subject = percentPart.substring(startOffset, percentPart.length() - endOffset);
        String remainder = null;
        int indexOfDot = percentPart.indexOf(".");
        if (indexOfDot != -1) {
            subject = percentPart.substring(startOffset, indexOfDot);
            remainder = percentPart.substring(indexOfDot + 1, percentPart.length() - endOffset);
        }
        ModlValue value = this.getValueForReference(subject);
        if (remainder != null) {
            String[] remainderHolder = new String[]{remainder};
            value = this.getValueForReferenceRecursive(value, remainderHolder);
            remainder = remainderHolder[0];
        }
        if (value == null) {
            return new ModlObject.String(stringToTransform);
        }
        if (value instanceof ModlObject.String) {
            subject = ((ModlObject.String)value).string;
        } else if (value instanceof ModlObject.Number) {
            if (remainder == null) {
                return value;
            }
            subject = ((ModlObject.Number)value).number;
        } else {
            return value;
        }
        if (remainder != null) {
            subject = this.runMethods(subject, remainder);
        }
        stringToTransform = stringToTransform.replace(percentPart, subject);
        return new ModlObject.String(stringToTransform);
    }

    private String runMethods(String subject, String remainder) {
        String[] methods = remainder.split("\\.");
        if (methods.length == 0) {
            methods = new String[]{remainder};
        }
        boolean stalled = false;
        for (String method : methods) {
            if (!stalled) {
                if (method.contains("(")) {
                    int startParamsIndex = method.indexOf("(");
                    String paramsString = method.substring(startParamsIndex + 1, method.length() - 1);
                    String methodString = method.substring(0, startParamsIndex);
                    subject = Interpreter.variableMethods.transform(methodString, subject + "," + paramsString);
                    remainder = null;
                    continue;
                }
                if (!Interpreter.variableMethods.isVariableMethod(method)) {
                    subject = subject + "." + method;
                    remainder = "";
                    stalled = true;
                    continue;
                }
                Matcher matcher = VariableMethods.STRING.matcher(method);
                if (!matcher.find() || matcher.groupCount() <= 0) continue;
                String match = matcher.group(0);
                remainder = method.substring(match.length());
                if (!match.equals(method)) {
                    method = match;
                }
                subject = Interpreter.variableMethods.transform(method, subject);
                continue;
            }
            remainder = remainder + "." + method;
        }
        if (remainder != null) {
            subject = subject + remainder;
        }
        return subject;
    }

    private ModlValue getValueForReference(String subject) {
        String remainder;
        boolean isNested;
        int indexOfGreaterThanSymbol = subject.indexOf(".");
        boolean bl = isNested = indexOfGreaterThanSymbol > -1;
        if (isNested) {
            remainder = subject.substring(indexOfGreaterThanSymbol + 1);
            subject = subject.substring(0, indexOfGreaterThanSymbol);
        } else {
            remainder = null;
        }
        ModlValue value = null;
        boolean found = false;
        Integer i = 0;
        while (i < this.numberedVariables.size()) {
            if (subject.equals(i.toString())) {
                value = this.numberedVariables.get(i);
                found = true;
                break;
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        if (!found) {
            for (Map.Entry<String, ModlValue> variableEntry : this.variables.entrySet()) {
                if (!subject.equals(variableEntry.getKey())) continue;
                value = variableEntry.getValue();
                found = true;
                break;
            }
        }
        if (!found) {
            for (Map.Entry<String, ModlValue> variableEntry : this.valuePairs.entrySet()) {
                if (!subject.equals(variableEntry.getKey()) && !subject.equals("_" + variableEntry.getKey())) continue;
                value = variableEntry.getValue();
                break;
            }
        }
        if (value != null && isNested) {
            return this.getValueForReferenceRecursive(value, new String[]{remainder});
        }
        return value;
    }

    private ModlValue getValueForReferenceRecursive(ModlValue ctx, String[] keyHolder) {
        ModlValue newCtx;
        String currentKey;
        String remainder;
        boolean isNested;
        String key = keyHolder[0];
        int indexOfGreaterThanSymbol = key.indexOf(".");
        boolean bl = isNested = indexOfGreaterThanSymbol > -1;
        if (isNested) {
            remainder = key.substring(indexOfGreaterThanSymbol + 1);
            currentKey = key.substring(0, indexOfGreaterThanSymbol);
        } else {
            keyHolder[0] = remainder = null;
            currentKey = key;
        }
        if (StringTransformer.isNumber(currentKey)) {
            if (!(ctx instanceof ModlObject.Array)) {
                throw new RuntimeException("Object reference is numerical for non-Array value");
            }
            int index = Integer.parseInt(currentKey);
            newCtx = ctx.get(index);
        } else {
            currentKey = ((ModlObject.String)this.transformString((String)currentKey)).string;
            if (ctx instanceof ModlObject.Pair) {
                if (!currentKey.equals(((ModlObject.Pair)ctx).getKey().string)) {
                    throw new RuntimeException("Object reference should match the key name for a Pair");
                }
                newCtx = ((ModlObject.Pair)ctx).getModlValue();
            } else if (ctx instanceof ModlObject.Map || ctx instanceof ModlObject.Array) {
                newCtx = ctx.get(currentKey);
            } else {
                keyHolder[0] = key;
                newCtx = ctx;
                isNested = false;
            }
        }
        if (isNested) {
            keyHolder[0] = remainder;
            return this.getValueForReferenceRecursive(newCtx, keyHolder);
        }
        if (newCtx == null) {
            keyHolder[0] = currentKey;
        }
        return newCtx;
    }
}

