/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.parser.printers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

public class ModlValueJsonSerializer
extends JsonSerializer<ModlValue> {
    public void serialize(ModlValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ModlValueJsonSerializer.serializeInternal(value, gen, serializers, false);
    }

    public static void serializeStructure(ModlObject.Structure structure, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ModlValueJsonSerializer.serializeInternal(structure, gen, serializers);
    }

    private static void serializeInternal(ModlObject.Structure structure, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        ModlValueJsonSerializer.serializeInternal(structure, gen, serializers, true);
    }

    public static void serializeInternal(ModlObject.Structure structure, JsonGenerator gen, SerializerProvider serializers, boolean startObject) throws IOException {
        if (structure == null) {
            return;
        }
        if (structure instanceof ModlObject.Array) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Array)structure, gen, serializers);
        }
        if (structure instanceof ModlObject.Pair) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Pair)structure, gen, serializers, startObject);
        }
        if (structure instanceof ModlObject.Map) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Map)structure, gen, serializers);
        }
    }

    private static void serializeInternal(ModlObject.Map map, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (map == null) {
            return;
        }
        if (map.getPairs() != null) {
            gen.writeStartObject();
            for (ModlObject.Pair pair : map.getPairs()) {
                ModlValueJsonSerializer.serializeInternal(pair, gen, serializers, false);
            }
            gen.writeEndObject();
        } else {
            gen.writeStartObject();
            gen.writeEndObject();
        }
    }

    public static void serializeInternal(ModlValue value, JsonGenerator gen, SerializerProvider serializers, boolean startObject) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof ModlObject.Pair) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Pair)value, gen, serializers, startObject);
        }
        if (value instanceof ModlObject.Map) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Map)value, gen, serializers);
        }
        if (value instanceof ModlObject.Array) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Array)value, gen, serializers);
        }
        if (value instanceof ModlObject.Number) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Number)value, gen, serializers);
        }
        if (value instanceof ModlObject.True) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.True)value, gen, serializers);
        }
        if (value instanceof ModlObject.False) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.False)value, gen, serializers);
        }
        if (value instanceof ModlObject.Null) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.Null)value, gen, serializers);
        }
        if (value instanceof ModlObject.String) {
            ModlValueJsonSerializer.serializeInternal((ModlObject.String)value, gen, serializers);
        }
    }

    private static void serializeInternal(ModlObject.Pair pair, JsonGenerator gen, SerializerProvider serializers, boolean startObject) throws IOException {
        if (pair == null) {
            return;
        }
        if (startObject) {
            gen.writeStartObject();
        }
        gen.writeFieldName(pair.getKey().string);
        ModlValueJsonSerializer.serializeInternal(pair.getModlValue(), gen, serializers, startObject);
        if (startObject) {
            gen.writeEndObject();
        }
    }

    private static void serializeInternal(ModlObject.Array array, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (array == null) {
            return;
        }
        if (array.getValues() != null) {
            gen.writeStartArray();
            for (ModlValue value : array.getValues()) {
                boolean startObject = false;
                if (value instanceof ModlObject.Pair) {
                    startObject = true;
                }
                ModlValueJsonSerializer.serializeInternal(value, gen, serializers, startObject);
            }
            gen.writeEndArray();
        } else {
            gen.writeStartArray();
            gen.writeEndArray();
        }
    }

    private static void serializeInternal(ModlObject.Number number, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (number == null) {
            return;
        }
        gen.writeNumber(number.number);
    }

    private static void serializeInternal(ModlObject.True trueVal, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (trueVal == null) {
            return;
        }
        gen.writeBoolean(true);
    }

    private static void serializeInternal(ModlObject.False falseVal, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (falseVal == null) {
            return;
        }
        gen.writeBoolean(false);
    }

    private static void serializeInternal(ModlObject.Null nullVal, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (nullVal == null) {
            return;
        }
        gen.writeNull();
    }

    private static void serializeInternal(ModlObject.String string, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (string == null) {
            return;
        }
        if (string.string != null) {
            gen.writeString(string.string);
        } else {
            gen.writeString("");
        }
    }
}

