/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.modlObject;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.printers.ModlObjectJsonSerializer;

@JsonSerialize(using=ModlObjectJsonSerializer.class)
public class ModlObject
extends ModlValue {
    protected List<Structure> structures = new LinkedList<Structure>();

    @Override
    public boolean isModlObject() {
        return true;
    }

    public List<Structure> getStructures() {
        return this.structures;
    }

    @Override
    public List<? extends ModlValue> getModlValues() {
        return this.structures;
    }

    public void addStructure(Structure structure) {
        if (structure != null) {
            this.structures.add(structure);
        }
    }

    @Override
    public List<java.lang.String> getKeys() {
        LinkedList<java.lang.String> keys = new LinkedList<java.lang.String>();
        for (Structure structure : this.structures) {
            if (!(structure instanceof Pair)) continue;
            Pair pair = (Pair)structure;
            keys.add(pair.getKey().string);
        }
        return keys;
    }

    @Override
    public ModlValue get(java.lang.String name) {
        for (Structure structure : this.structures) {
            if (!(structure instanceof Pair)) continue;
            Pair pair = (Pair)structure;
            if (!pair.getKey().string.equals(name)) continue;
            return pair.getModlValue();
        }
        return null;
    }

    @Override
    public ModlValue get(Integer index) {
        return this.structures.get(index);
    }

    public static class Null
    extends ModlValue {
        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public Object getValue() {
            return null;
        }

        public java.lang.String toString() {
            return "null";
        }
    }

    public static class False
    extends ModlValue {
        @Override
        public boolean isFalse() {
            return true;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public Object getValue() {
            return false;
        }

        public java.lang.String toString() {
            return "false";
        }
    }

    public static class True
    extends ModlValue {
        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public Object getValue() {
            return true;
        }

        public java.lang.String toString() {
            return "true";
        }
    }

    public static class Number
    extends ModlValue {
        public final java.lang.String number;

        public Number(java.lang.String number) {
            this.number = number;
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.number;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        public java.lang.String toString() {
            return this.number;
        }
    }

    public static class String
    extends ModlValue {
        public java.lang.String string;

        public String(java.lang.String string) {
            this.string = string;
        }

        @Override
        public boolean isString() {
            return true;
        }

        public java.lang.String toString() {
            return this.string;
        }

        @Override
        public Object getValue() {
            return this.string;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            String string1 = (String)o;
            return Objects.equals(this.string, string1.string);
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class Pair
    extends Structure {
        private String key;
        private ModlValue modlValue;

        public Pair() {
        }

        public Pair(String key, ModlValue modlValue) {
            this.key = key;
            this.modlValue = modlValue;
        }

        @Override
        public boolean isPair() {
            return true;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public List<java.lang.String> getKeys() {
            LinkedList<java.lang.String> keys = new LinkedList<java.lang.String>();
            keys.add(this.key.string);
            return keys;
        }

        public ModlValue getModlValue() {
            return this.modlValue;
        }

        public void addModlValue(ModlValue value) {
            if (value == null) {
                return;
            }
            if (this.modlValue == null) {
                this.modlValue = value;
                return;
            }
            ModlValue oldValue = this.modlValue;
            if (this.modlValue instanceof Map) {
                ((Map)this.modlValue).addPair((Pair)value);
            } else if (this.modlValue instanceof Pair && value instanceof Pair) {
                Pair oldPair = (Pair)oldValue;
                Pair newPair = (Pair)value;
                if (oldPair.getKey().equals(newPair.getKey())) {
                    this.modlValue = new Array();
                    ((Array)this.modlValue).addValue(oldValue);
                    ((Array)this.modlValue).addValue(value);
                } else {
                    this.modlValue = new Map();
                    ((Map)this.modlValue).addPair((Pair)oldValue);
                    ((Map)this.modlValue).addPair((Pair)value);
                }
            } else if (this.modlValue instanceof Array) {
                ((Array)this.modlValue).addValue(value);
            } else {
                this.modlValue = new Array();
                ((Array)this.modlValue).addValue(oldValue);
                ((Array)this.modlValue).addValue(value);
            }
        }

        @Override
        public Object getValue() {
            return this.modlValue;
        }

        @Override
        public List<? extends ModlValue> getModlValues() {
            LinkedList<ModlValue> values = new LinkedList<ModlValue>();
            values.add(this.modlValue);
            return values;
        }

        public java.lang.String toString() {
            return "Pair{key=" + this.key + ", modlValue=" + this.modlValue + '}';
        }
    }

    public static class Array
    extends Structure {
        List<ModlValue> values = new LinkedList<ModlValue>();

        @Override
        public boolean isArray() {
            return true;
        }

        public void addValue(ModlValue value) {
            this.values.add(value);
        }

        @Override
        public ModlValue get(Integer index) {
            return this.values.get(index);
        }

        public Pair get(String name) {
            for (ModlValue v : this.values) {
                if (!(v instanceof Pair) || !((Pair)v).getKey().string.equals(name.string)) continue;
                return (Pair)v;
            }
            return null;
        }

        public List<ModlValue> getValues() {
            return this.values;
        }

        @Override
        public List<? extends ModlValue> getModlValues() {
            return this.values;
        }

        public java.lang.String toString() {
            java.lang.String valuesStr = this.values.stream().map(v -> {
                if (v.isNumber()) {
                    return v.toString();
                }
                return "\"" + v.toString() + "\"";
            }).collect(Collectors.joining(", "));
            return "[" + valuesStr + "]";
        }
    }

    public static class Map
    extends Structure {
        List<Pair> pairs = new LinkedList<Pair>();

        @Override
        public boolean isMap() {
            return true;
        }

        public void addPair(Pair pair) {
            this.pairs.add(pair);
        }

        public ModlValue get(String key) {
            for (Pair pair : this.pairs) {
                if (!pair.getKey().string.equals(key.string)) continue;
                return pair.getModlValue();
            }
            return null;
        }

        @Override
        public Pair get(Integer index) {
            return this.pairs.get(index);
        }

        public List<Pair> getPairs() {
            return this.pairs;
        }

        @Override
        public List<? extends ModlValue> getModlValues() {
            return this.pairs;
        }

        @Override
        public ModlValue get(java.lang.String name) {
            for (Pair pair : this.pairs) {
                if (!pair.getKey().string.equals(name)) continue;
                return pair.getModlValue();
            }
            return null;
        }

        public java.lang.String toString() {
            java.lang.String s = this.pairs.stream().map(p -> "\"" + p.getKey() + "\"=>\"" + p.getValue().toString() + "\"").collect(Collectors.joining(", "));
            return "{" + s + '}';
        }
    }

    public static abstract class Structure
    extends ModlValue {
    }
}

