/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import uk.modl.interpreter.UnicodeEscapeReplacer;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlObjectTreeWalker;
import uk.modl.parser.RawModlObject;

public class StringEscapeReplacer {
    private static Map<String, String> replacements = new LinkedHashMap<String, String>();

    public static void replaceAll(ModlObject rawModlObject) {
        ModlObjectTreeWalker walker = new ModlObjectTreeWalker(rawModlObject);
        walker.walk(v -> {
            if (v instanceof ModlObject.String) {
                ModlObject.String str = (ModlObject.String)v;
                str.string = StringEscapeReplacer.replace(str.string);
            }
            if (v instanceof MutablePair) {
                MutablePair p = (MutablePair)v;
                if (p.left instanceof String) {
                    p.left = StringEscapeReplacer.replace((String)p.left);
                }
                if (p.right instanceof String) {
                    p.right = StringEscapeReplacer.replace((String)p.right);
                }
            }
            if (v instanceof RawModlObject.Condition) {
                RawModlObject.Condition c = (RawModlObject.Condition)v;
                c.setKey(StringEscapeReplacer.replace(c.getKey()));
            }
        });
    }

    public static String replace(String stringToTransform) {
        if (stringToTransform != null) {
            stringToTransform = UnicodeEscapeReplacer.convertUnicodeSequences(stringToTransform);
            if (replacements.isEmpty()) {
                StringEscapeReplacer.loadReplacements();
            }
            for (Map.Entry<String, String> replacement : replacements.entrySet()) {
                if (!stringToTransform.contains(replacement.getKey())) continue;
                stringToTransform = stringToTransform.replace(replacement.getKey(), replacement.getValue());
            }
        }
        return stringToTransform;
    }

    private static synchronized void loadReplacements() {
        replacements.put("\\%", "%");
        replacements.put("~%", "%");
        replacements.put("~\\", "\\");
        replacements.put("\\\\", "\\");
        replacements.put("~~", "~");
        replacements.put("\\~", "~");
        replacements.put("~(", "(");
        replacements.put("\\(", "(");
        replacements.put("~)", ")");
        replacements.put("\\)", ")");
        replacements.put("~[", "[");
        replacements.put("\\[", "[");
        replacements.put("~]", "]");
        replacements.put("\\]", "]");
        replacements.put("~{", "{");
        replacements.put("\\{", "{");
        replacements.put("~}", "}");
        replacements.put("\\}", "}");
        replacements.put("~;", ";");
        replacements.put("\\;", ";");
        replacements.put("~:", ":");
        replacements.put("\\:", ":");
        replacements.put("~`", "`");
        replacements.put("\\`", "`");
        replacements.put("~\"", "\"");
        replacements.put("\\\"", "\"");
        replacements.put("~=", "=");
        replacements.put("\\=", "=");
        replacements.put("~/", "/");
        replacements.put("\\/", "/");
        replacements.put("<", "<");
        replacements.put("\\<", "<");
        replacements.put("~>", ">");
        replacements.put("\\>", ">");
        replacements.put("~&", "&");
        replacements.put("\\&", "&");
        replacements.put("!", "!");
        replacements.put("\\!", "!");
        replacements.put("~|", "|");
        replacements.put("\\|", "|");
        replacements.put("\\t", "\t");
        replacements.put("\\n", "\n");
        replacements.put("\\b", "\b");
        replacements.put("\\f", "\f");
        replacements.put("\\r", "\r");
    }
}

