/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.List;
import java.util.Map;
import uk.modl.interpreter.VariableMethodLoader;
import uk.modl.modlObject.ModlObject;
import uk.modl.modlObject.ModlValue;

class InstructionProcessor {
    private InstructionProcessor() {
    }

    static ModlValue processLoadInstruction(List<String> filenames) {
        ModlObject.Array result = new ModlObject.Array();
        for (String filename : filenames) {
            result.addValue(new ModlObject.String(filename));
        }
        return result;
    }

    static ModlValue processClassInstruction(Map<String, Map<String, Object>> classes) {
        ModlObject.Array result = new ModlObject.Array();
        for (String key : classes.keySet()) {
            ModlObject.Map map = new ModlObject.Map();
            ModlObject.String pairKey = new ModlObject.String(key);
            ModlObject.Map classDetails = new ModlObject.Map();
            Map<String, Object> klass = classes.get(key);
            InstructionProcessor.addClassField(classDetails, klass, "name", "*name");
            if (klass.containsKey("object_type")) {
                InstructionProcessor.addClassField(classDetails, klass, "superclass", "object_type");
            } else {
                InstructionProcessor.addClassField(classDetails, klass, "superclass", "*superclass");
            }
            InstructionProcessor.addClassParams(classDetails, klass);
            InstructionProcessor.addClassField(classDetails, klass, "expect", "*expect");
            for (String k : klass.keySet()) {
                if (k.startsWith("*")) continue;
                InstructionProcessor.addClassField(classDetails, klass, k, k);
            }
            ModlObject.Pair pair = new ModlObject.Pair(pairKey, classDetails);
            map.addPair(pair);
            result.addValue(map);
        }
        return result;
    }

    private static void addClassField(ModlObject.Map classDetails, Map<String, Object> klass, String fieldName, String keyName) {
        Object nameObject = klass.get(keyName);
        if (nameObject != null) {
            ModlObject.String classKeyObject = new ModlObject.String(fieldName);
            if (nameObject instanceof String) {
                String value = (String)nameObject;
                ModlObject.String classValueObject = new ModlObject.String(value);
                classDetails.addPair(new ModlObject.Pair(classKeyObject, classValueObject));
            } else if (nameObject instanceof ModlObject.String) {
                String value = ((ModlObject.String)nameObject).string;
                ModlObject.String classValueObject = new ModlObject.String(value);
                classDetails.addPair(new ModlObject.Pair(classKeyObject, classValueObject));
            } else if (nameObject instanceof ModlObject.Array) {
                List<ModlValue> values = ((ModlObject.Array)nameObject).getValues();
                ModlObject.Array array = new ModlObject.Array();
                for (ModlValue v : values) {
                    array.addValue(v);
                }
                classDetails.addPair(new ModlObject.Pair(classKeyObject, array));
            } else {
                String value = "Unknown field type for class " + nameObject.getClass().getName();
                ModlObject.String classValueObject = new ModlObject.String(value);
                classDetails.addPair(new ModlObject.Pair(classKeyObject, classValueObject));
            }
        }
    }

    private static void addClassParams(ModlObject.Map classDetails, Map<String, Object> klass) {
        ModlObject.String classKeyObject = new ModlObject.String("assign");
        ModlObject.Array paramsArray = new ModlObject.Array();
        for (String key : klass.keySet()) {
            if (!key.startsWith("*param")) continue;
            Object nameObject = klass.get(key);
            if (nameObject instanceof List) {
                List values = (List)nameObject;
                ModlObject.Array array = new ModlObject.Array();
                for (ModlValue v : values) {
                    array.addValue(v);
                }
                paramsArray.addValue(array);
                continue;
            }
            String value = "Unknown field type for class " + nameObject.getClass().getName();
            throw new RuntimeException(value);
        }
        if (paramsArray.getModlValues().size() > 0) {
            classDetails.addPair(new ModlObject.Pair(classKeyObject, paramsArray));
        }
    }

    static ModlValue processMethodInstruction(List<VariableMethodLoader.MethodDescriptor> methodList) {
        ModlObject.Array result = new ModlObject.Array();
        for (VariableMethodLoader.MethodDescriptor mthd : methodList) {
            ModlObject.Map map = new ModlObject.Map();
            ModlObject.String pairKey = new ModlObject.String(mthd.id);
            ModlObject.Map methodDetails = new ModlObject.Map();
            methodDetails.addPair(new ModlObject.Pair(new ModlObject.String("name"), new ModlObject.String(mthd.name)));
            methodDetails.addPair(new ModlObject.Pair(new ModlObject.String("transform"), new ModlObject.String(mthd.transform)));
            ModlObject.Pair pair = new ModlObject.Pair(pairKey, methodDetails);
            map.addPair(pair);
            result.addValue(map);
        }
        return result;
    }
}

