/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.modlObject;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.LinkedList;
import java.util.List;
import uk.modl.modlObject.ModlValue;
import uk.modl.parser.printers.ModlObjectJsonSerializer;

@JsonSerialize(using=ModlObjectJsonSerializer.class)
public class ModlObject
implements ModlValue {
    protected List<Structure> structures = new LinkedList<Structure>();

    @Override
    public boolean isModlObject() {
        return true;
    }

    public List<Structure> getStructures() {
        return this.structures;
    }

    @Override
    public List<? extends ModlValue> getModlValues() {
        return this.structures;
    }

    public void addStructure(Structure structure) {
        if (structure != null) {
            this.structures.add(structure);
        }
    }

    @Override
    public List<java.lang.String> getKeys() {
        LinkedList<java.lang.String> keys = new LinkedList<java.lang.String>();
        for (Structure structure : this.structures) {
            if (!(structure instanceof Pair)) continue;
            Pair pair = (Pair)structure;
            keys.add(pair.getKey().string);
        }
        return keys;
    }

    @Override
    public ModlValue get(java.lang.String name) {
        for (Structure structure : this.structures) {
            if (!(structure instanceof Pair)) continue;
            Pair pair = (Pair)structure;
            if (!pair.getKey().string.equals(name)) continue;
            return pair.getModlValue();
        }
        return null;
    }

    @Override
    public ModlValue get(Integer index) {
        return this.structures.get(index);
    }

    public class Null
    implements ModlValue {
        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public Object getValue() {
            return null;
        }
    }

    public class False
    implements ModlValue {
        @Override
        public boolean isFalse() {
            return true;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public Object getValue() {
            return false;
        }
    }

    public class True
    implements ModlValue {
        @Override
        public boolean isTrue() {
            return true;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }

        @Override
        public Object getValue() {
            return true;
        }
    }

    public class Number
    implements ModlValue {
        public final java.lang.String number;

        @Override
        public boolean isNumber() {
            return true;
        }

        public Number(java.lang.String number) {
            this.number = number;
        }

        @Override
        public Object getValue() {
            return this.number;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    public class String
    implements ModlValue {
        public final java.lang.String string;

        @Override
        public boolean isString() {
            return true;
        }

        public String(java.lang.String string) {
            this.string = string;
        }

        public java.lang.String toString() {
            return this.string;
        }

        @Override
        public Object getValue() {
            return this.string;
        }

        @Override
        public boolean isTerminal() {
            return true;
        }
    }

    public class Pair
    implements Structure,
    ModlValue {
        private String key;
        private ModlValue modlValue;

        @Override
        public boolean isPair() {
            return true;
        }

        public Pair() {
        }

        public Pair(String key, ModlValue modlValue) {
            this.key = key;
            this.modlValue = modlValue;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public List<java.lang.String> getKeys() {
            LinkedList<java.lang.String> keys = new LinkedList<java.lang.String>();
            keys.add(this.key.string);
            return keys;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public ModlValue getModlValue() {
            return this.modlValue;
        }

        public void addModlValue(ModlValue value) {
            if (value == null) {
                return;
            }
            if (this.modlValue == null) {
                this.modlValue = value;
                return;
            }
            ModlValue oldValue = this.modlValue;
            if (this.modlValue instanceof Map) {
                ((Map)this.modlValue).addPair((Pair)value);
            } else if (this.modlValue instanceof Pair && value instanceof Pair) {
                this.modlValue = new Map();
                ((Map)this.modlValue).addPair((Pair)oldValue);
                ((Map)this.modlValue).addPair((Pair)value);
            } else {
                this.modlValue = new Array();
                ((Array)this.modlValue).addValue(oldValue);
                ((Array)this.modlValue).addValue(value);
            }
        }

        @Override
        public Object getValue() {
            return this.modlValue;
        }

        @Override
        public List<? extends ModlValue> getModlValues() {
            LinkedList<ModlValue> values = new LinkedList<ModlValue>();
            values.add(this.modlValue);
            return values;
        }
    }

    public class Array
    implements Structure,
    ModlValue {
        List<ModlValue> values = new LinkedList<ModlValue>();

        @Override
        public boolean isArray() {
            return true;
        }

        public void addValue(ModlValue value) {
            this.values.add(value);
        }

        @Override
        public ModlValue get(Integer index) {
            return this.values.get(index);
        }

        public Pair get(String name) {
            for (ModlValue v : this.values) {
                if (!(v instanceof Pair) || !((Pair)v).getKey().string.equals(name.string)) continue;
                return (Pair)v;
            }
            return null;
        }

        public List<ModlValue> getValues() {
            return this.values;
        }

        @Override
        public List<? extends ModlValue> getModlValues() {
            return this.values;
        }
    }

    public class Map
    implements Structure,
    ModlValue {
        List<Pair> pairs = new LinkedList<Pair>();

        @Override
        public boolean isMap() {
            return true;
        }

        public void addPair(Pair pair) {
            this.pairs.add(pair);
        }

        public ModlValue get(String key) {
            for (Pair pair : this.pairs) {
                if (!pair.getKey().string.equals(key.string)) continue;
                return pair.getModlValue();
            }
            return null;
        }

        @Override
        public Pair get(Integer index) {
            return this.pairs.get(index);
        }

        public List<Pair> getPairs() {
            return this.pairs;
        }

        @Override
        public List<? extends ModlValue> getModlValues() {
            return this.pairs;
        }

        @Override
        public List<java.lang.String> getKeys() {
            LinkedList<java.lang.String> keys = new LinkedList<java.lang.String>();
            for (Structure structure : this.pairs) {
                if (!(structure instanceof Pair)) continue;
                Pair pair = (Pair)structure;
                keys.add(pair.getKey().string);
            }
            return keys;
        }

        @Override
        public ModlValue get(java.lang.String name) {
            for (Pair pair : this.pairs) {
                if (!pair.getKey().string.equals(name)) continue;
                return pair.getModlValue();
            }
            return null;
        }
    }

    public static interface Structure
    extends ModlValue {
    }
}

