/*
 * Decompiled with CFR 0.152.
 */
package uk.modl.interpreter;

import java.util.LinkedHashMap;
import java.util.Map;

public class StringEscapeReplacer {
    static Map<String, String> replacements = new LinkedHashMap<String, String>();

    public static String replace(String stringToTransform) {
        if (replacements.isEmpty()) {
            StringEscapeReplacer.loadReplacements();
        }
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            if (stringToTransform.indexOf(replacement.getKey()) <= -1) continue;
            stringToTransform = stringToTransform.replace(replacement.getKey(), replacement.getValue());
        }
        return stringToTransform;
    }

    private static void loadReplacements() {
        replacements.put("~\\", "\\");
        replacements.put("\\\\", "\\");
        replacements.put("~~", "~");
        replacements.put("\\~", "~");
        replacements.put("~(", "(");
        replacements.put("\\(", "(");
        replacements.put("~)", ")");
        replacements.put("\\)", ")");
        replacements.put("~[", "[");
        replacements.put("\\[", "[");
        replacements.put("~]", "]");
        replacements.put("\\]", "]");
        replacements.put("~{", "{");
        replacements.put("\\{", "{");
        replacements.put("~}", "}");
        replacements.put("\\}", "}");
        replacements.put("~;", ";");
        replacements.put("\\;", ";");
        replacements.put("~:", ":");
        replacements.put("\\:", ":");
        replacements.put("~`", "`");
        replacements.put("\\`", "`");
        replacements.put("~\"", "\"");
        replacements.put("\\\"", "\"");
        replacements.put("~=", "=");
        replacements.put("\\=", "=");
        replacements.put("~/", "/");
        replacements.put("\\/", "/");
        replacements.put("<", "<");
        replacements.put("\\<", "<");
        replacements.put("~>", ">");
        replacements.put("\\>", ">");
        replacements.put("~&", "&");
        replacements.put("\\&", "&");
        replacements.put("!", "!");
        replacements.put("\\!", "!");
        replacements.put("~|", "|");
        replacements.put("\\|", "|");
        replacements.put("\\t", "\t");
        replacements.put("\\n", "\n");
        replacements.put("\\b", "\b");
        replacements.put("\\f", "\f");
        replacements.put("\\r", "\r");
    }
}

