/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.Optional;
import java.util.UUID;
import org.json.JSONObject;

public class TemplatePreview {
    private UUID id;
    private String templateType;
    private int version;
    private String body;
    private String subject;

    public TemplatePreview(String content) {
        JSONObject responseBodyAsJson = new JSONObject(content);
        this.build(responseBodyAsJson);
    }

    public TemplatePreview(JSONObject data) {
        this.build(data);
    }

    private void build(JSONObject data) {
        this.id = UUID.fromString(data.getString("id"));
        this.templateType = data.getString("type");
        this.version = data.getInt("version");
        this.body = data.getString("body");
        this.subject = data.isNull("subject") ? null : data.getString("subject");
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String toString() {
        return "Template{id=" + this.id + ", templateType='" + this.templateType + '\'' + ", version=" + this.version + ", body='" + this.body + '\'' + ", subject='" + this.subject + '\'' + '}';
    }
}

