/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.service.notify;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtils {
    public static Map<String, Object> jsonToMap(JSONObject json) throws JSONException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != null && json != JSONObject.NULL) {
            retMap = JsonUtils.toMap(json);
        }
        return retMap;
    }

    private static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        object.keySet().forEach(key -> map.put((String)key, JsonUtils.parseValue(object.get(key))));
        return map;
    }

    public static List<Object> jsonToList(JSONArray json) throws JSONException {
        List<Object> retList = new ArrayList<Object>();
        if (json != null) {
            retList = JsonUtils.toList(json);
        }
        return retList;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        array.forEach(item -> list.add(JsonUtils.parseValue(item)));
        return list;
    }

    private static Object parseValue(Object value) {
        if (value instanceof JSONArray) {
            return JsonUtils.toList((JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return JsonUtils.toMap((JSONObject)value);
        }
        return value;
    }
}

