/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.test;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import uk.gov.ida.saml.core.test.PemCertificateStrings;

public final class TestCertificateStrings {
    public static final String TEST_ENTITY_ID = "a-test-entity";
    public static final String TEST_ENTITY_ID_EC = "a-test-entity-ec";
    public static final Map<String, String> PUBLIC_SIGNING_CERTS;
    public static final Map<String, List<String>> PUBLIC_ENCRYPTION_CERTS;
    public static final Map<String, String> PRIVATE_SIGNING_KEYS;
    public static final Map<String, List<String>> PRIVATE_ENCRYPTION_KEYS;
    public static final String TEST_PRIVATE_KEY;
    public static final String TEST_PRIVATE_EC_KEY;
    public static final String TEST_PUBLIC_CERT;
    public static final String TEST_PUBLIC_EC_CERT;
    public static final String EXPIRED_SIGNING_PUBLIC_CERT;
    public static final String EXPIRED_SELF_SIGNED_SIGNING_PUBLIC_CERT;
    public static final String EXPIRED_SIGNING_PRIVATE_KEY;
    public static final String HUB_TEST_PRIVATE_ENCRYPTION_KEY;
    public static final String HUB_TEST_PRIVATE_SIGNING_KEY;
    public static final String HUB_CONNECTOR_TEST_PRIVATE_ENCRYPTION_KEY;
    public static final String HUB_CONNECTOR_TEST_PRIVATE_SIGNING_KEY;
    public static final String HUB_TEST_PRIVATE_SECONDARY_SIGNING_KEY;
    public static final String HUB_TEST_PUBLIC_ENCRYPTION_CERT;
    public static final String HUB_TEST_PUBLIC_SIGNING_CERT;
    public static final String HUB_CONNECTOR_TEST_PUBLIC_ENCRYPTION_CERT;
    public static final String HUB_CONNECTOR_TEST_PUBLIC_SIGNING_CERT;
    public static final String HUB_TEST_SECONDARY_PUBLIC_SIGNING_CERT;
    public static final String TEST_RP_PRIVATE_ENCRYPTION_KEY;
    public static final String TEST_RP_PRIVATE_SIGNING_KEY;
    public static final String TEST_RP_PUBLIC_ENCRYPTION_CERT;
    public static final String TEST_RP_PUBLIC_SIGNING_CERT;
    public static final String TEST_RP_MS_PRIVATE_ENCRYPTION_KEY;
    public static final String TEST_RP_MS_PRIVATE_SIGNING_KEY;
    public static final String TEST_RP_MS_PUBLIC_ENCRYPTION_CERT;
    public static final String TEST_RP_MS_PUBLIC_SIGNING_CERT;
    public static final String HEADLESS_RP_PUBLIC_SIGNING_CERT;
    public static final String HEADLESS_RP_PRIVATE_SIGNING_KEY;
    public static final String HEADLESS_RP_MS_PUBLIC_SIGNING_CERT;
    public static final String HEADLESS_RP_MS_PRIVATE_SIGNING_KEY;
    public static final String HEADLESS_RP_MS_PRIVATE_ENCRYPTION_KEY;
    public static final String HEADLESS_RP_PUBLIC_ENCRYPTION_CERT;
    public static final String HEADLESS_RP_MS_PUBLIC_ENCRYPTION_CERT;
    public static final String STUB_IDP_PUBLIC_PRIMARY_PRIVATE_KEY;
    public static final String STUB_IDP_PUBLIC_PRIMARY_CERT;
    public static final String STUB_IDP_PUBLIC_SECONDARY_PRIVATE_KEY;
    public static final String STUB_IDP_PUBLIC_SECONDARY_CERT;
    public static final String STUB_COUNTRY_PUBLIC_PRIMARY_PRIVATE_KEY;
    public static final String STUB_COUNTRY_PUBLIC_PRIMARY_CERT;
    public static final String STUB_COUNTRY_PUBLIC_SECONDARY_PRIVATE_KEY;
    public static final String STUB_COUNTRY_PUBLIC_SECONDARY_CERT;
    public static final String STUB_COUNTRY_PUBLIC_TERTIARY_PRIVATE_KEY;
    public static final String STUB_COUNTRY_PUBLIC_TERTIARY_CERT;
    public static final String STUB_COUNTRY_PUBLIC_EXPIRED_PRIVATE_KEY;
    public static final String STUB_COUNTRY_PUBLIC_EXPIRED_CERT;
    public static final String STUB_COUNTRY_PUBLIC_NOT_YET_VALID_PRIVATE_KEY;
    public static final String STUB_COUNTRY_PUBLIC_NOT_YET_VALID_CERT;
    public static final String UNCHAINED_PRIVATE_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBALGtlH968fIt6cYokQ8YWcvcNVfENKrkE3//yBSXI2IbUj6UVQpCZjD0bMShat4DPC+yYSw4mXo7XxvfkRiYLxzfWgKq8xL/4wjpBC457kmr2G8qujm7egoRxIS+SCQQtU/vQqXGRlXnlIZAuIZpGxlfJuQSz0pBQaZh4W4WBhGDAgMBAAECgYEAiYmPePsHzOtjmiQO3fuAj0D//deA2YRB4AR0shOorSnvCUgzaASsLFsY00EMg51Herh/ZgbOL4NEBUSTgdFULaACPQlAcPZc/BkKlP6n1Xz74KdtFKW8kxd0SoVxlL1WfHKP2KCs0IYMRtsWZdfcnF2ybu1sd0dHqL74BREo++kCQQDdRh39IDyD0QgQllmbpWTHsoU5BTAPVohYEx+9e2lTnkP2rhYIg3rTIQfaa0dRB4AO74nsyX7rDPtr1bziqj7VAkEAzY/1owrdby1v8rDx9LJ4cZeICnSIEje3vXC7e0qPqNArKAx1dTgt8x3mciTaDqcoz69Srks/OXzssKf+ZuKq9wJBAK9C61vj3aq2tYGV5NHgdeuqndTlJATyEDpao2hMyMc/cyt/BdqmcXGrFvJMyIcIvsiVuJRBoPKCLN5jxCFwoSUCQD2CKAQDSkLsG6VI4P1RMcz7hI9sUxLwbSBYTSEVLGtc7qzrHXJXvxgSCFR7RmxABGwwj9LrXR28ja5Gdk8e3/0CQB7pVgitNX6wSx5zB3fOasg7wgpOBsvQCPqlqYLG3+b9mPgZOg2vz97NeQJJQ3Ro0y9fHHo7Y0BCwGiPcBYVeU75devzZayFm4wGzXhpv3rLOwq61uo2mksyXy4b8Eu4diR64VFdxOJavbH5pQp7YNiPrzrtqxviU6ZGsDgda6VnuCKe9RlmT7qHd9DHHIiu/usS8Y8SZSOcCAwEAAQKBgHbU7QGPfK37qaK0ryVW8B6vwTe5mmDh2jQvZQtTkKzfBqye+OAcvg+Y3fUikZSe7MTsHifdi+yj2eVO97a61dnwXUUxGiEY5qi/1B0gWaSjt8cmvKjsvqmJbpEmwTTq1+wIVfJ8KvNUz+aq0KpspERMDynzaumNSluK3rqCDW3BAkEA9bUIJcz9OasluupCyiKDccvkkVdr8FPRayRabfgUltOqrAEQFMyvRlMui5znIE0OhdzZwtxUhxkpctB4MxQy2QJBAPGipvinjRj9EF2EPAbtovWHJEgoYGIpmCo/bgqGhUfEbPjdQXIiCWjP2umaN8jarKHouRNd2d6unJ/BnTEogb8CQGZtKRBY+9bmebwJm/4XlSQDEy1jfCObTVmUtf3RxQN7CVLavpFtIkP2uRiKN+9HMB6tijmpD7Oh0Z2DOhhQ+0ECQQCCuBlYH1xnjk/SJ31JyjkEVq28E4vAzvuwr0vaideEcbD6GMgU9HDesMOe6H0RPatyk7G71mPM4e19R4LAW0eFAkAXAEU8Mh96ML7paJ2zbgHW4PzGpYXzLoQQMfvMfZEiPjG0lb6lUbWXddWm9cw+Qh301Mh0cPCmiWqD79xvVYrMA==";
    public static final String UNCHAINED_PUBLIC_CERT = "MIICsDCCAhmgAwIBAgIJANxvwSnbFJp1MA0GCSqGSIb3DQEBBQUAMEUxCzAJBgNV\nBAYTAkFVMRMwEQYDVQQIEwpTb21lLVN0YXRlMSEwHwYDVQQKExhJbnRlcm5ldCBX\naWRnaXRzIFB0eSBMdGQwHhcNMTIxMTE0MTY1ODQyWhcNMTIxMjE0MTY1ODQyWjBF\nMQswCQYDVQQGEwJBVTETMBEGA1UECBMKU29tZS1TdGF0ZTEhMB8GA1UEChMYSW50\nZXJuZXQgV2lkZ2l0cyBQdHkgTHRkMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB\ngQCxrZR/evHyLenGKJEPGFnL3DVXxDSq5BN//8gUlyNiG1I+lFUKQmYw9GzEoWre\nAzwvsmEsOJl6O18b35EYmC8c31oCqvMS/+MI6QQuOe5Jq9hvKro5u3oKEcSEvkgk\nELVP70KlxkZV55SGQLiGaRsZXybkEs9KQUGmYeFuFgYRgwIDAQABo4GnMIGkMB0G\nA1UdDgQWBBSOu1RJmPHRe/fbGBv0hZzoyMk1QDB1BgNVHSMEbjBsgBSOu1RJmPHR\ne/fbGBv0hZzoyMk1QKFJpEcwRTELMAkGA1UEBhMCQVUxEzARBgNVBAgTClNvbWUt\nU3RhdGUxITAfBgNVBAoTGEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZIIJANxvwSnb\nFJp1MAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADgYEAFpCJ7hF1r9zqnGbQ\np33GQ0dCfuYYEXxGDkfN0aoxY2ubOk2D403Lrv091LvfYc8gd/R510AKIm3psVOC\nR1+/X1IUXNGKfqVMWC/QMqXIOG60SCXirbTZS77Ssye6hm8HENZZ4SQNIR+mHxHr\n8aMNpVcUBnhmehV84MCNZNXRuWU=";
    public static final String METADATA_SIGNING_A_PRIVATE_KEY;
    public static final String METADATA_SIGNING_A_PUBLIC_CERT;
    public static final String METADATA_SIGNING_B_PRIVATE_KEY;
    public static final String METADATA_SIGNING_B_PUBLIC_CERT;

    private TestCertificateStrings() {
    }

    private static String createInlineCertificate(String pemString) {
        String BEGIN = "-----BEGIN CERTIFICATE-----\n";
        String END = "\n-----END CERTIFICATE-----";
        return pemString.substring(pemString.lastIndexOf(BEGIN) + BEGIN.length(), pemString.indexOf(END));
    }

    private static String readPrivateKey(String name) {
        try {
            URL resource = Resources.getResource((String)("dev-keys/" + name));
            return Base64.getEncoder().encodeToString(Resources.toByteArray((URL)resource));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String getPrimaryPublicEncryptionCert(String issuerId) {
        return PUBLIC_ENCRYPTION_CERTS.get(issuerId).get(0);
    }

    public static String getSecondaryPublicEncryptionCert(String issuerId) {
        List<String> allCerts = PUBLIC_ENCRYPTION_CERTS.get(issuerId);
        if (allCerts.size() < 2) {
            throw new RuntimeException("No secondary public encryption cert for : " + issuerId);
        }
        return allCerts.get(1);
    }

    static {
        TEST_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_idp_signing_primary.pk8");
        TEST_PRIVATE_EC_KEY = TestCertificateStrings.readPrivateKey("hub_ec.pk8");
        TEST_PUBLIC_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_IDP_PUBLIC_SIGNING_CERT);
        TEST_PUBLIC_EC_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.HUB_TEST_EC_CERT);
        EXPIRED_SIGNING_PUBLIC_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.EXPIRED_SIGNING_PUBLIC_CERT);
        EXPIRED_SELF_SIGNED_SIGNING_PUBLIC_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.EXPIRED_SELF_SIGNED_SIGNING_PUBLIC_CERT);
        EXPIRED_SIGNING_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("expired_signing.pk8");
        HUB_TEST_PRIVATE_ENCRYPTION_KEY = TestCertificateStrings.readPrivateKey("hub_encryption_primary.pk8");
        HUB_TEST_PRIVATE_SIGNING_KEY = TestCertificateStrings.readPrivateKey("hub_signing_primary.pk8");
        HUB_CONNECTOR_TEST_PRIVATE_ENCRYPTION_KEY = TestCertificateStrings.readPrivateKey("hub_connector_encryption_primary.pk8");
        HUB_CONNECTOR_TEST_PRIVATE_SIGNING_KEY = TestCertificateStrings.readPrivateKey("hub_connector_signing_primary.pk8");
        HUB_TEST_PRIVATE_SECONDARY_SIGNING_KEY = TestCertificateStrings.readPrivateKey("hub_signing_secondary.pk8");
        HUB_TEST_PUBLIC_ENCRYPTION_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.HUB_TEST_PUBLIC_ENCRYPTION_CERT);
        HUB_TEST_PUBLIC_SIGNING_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.HUB_TEST_PUBLIC_SIGNING_CERT);
        HUB_CONNECTOR_TEST_PUBLIC_ENCRYPTION_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.HUB_CONNECTOR_TEST_PUBLIC_ENCRYPTION_CERT);
        HUB_CONNECTOR_TEST_PUBLIC_SIGNING_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.HUB_CONNECTOR_TEST_PUBLIC_SIGNING_CERT);
        HUB_TEST_SECONDARY_PUBLIC_SIGNING_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.HUB_TEST_SECONDARY_PUBLIC_SIGNING_CERT);
        TEST_RP_PRIVATE_ENCRYPTION_KEY = TestCertificateStrings.readPrivateKey("sample_rp_encryption_primary.pk8");
        TEST_RP_PRIVATE_SIGNING_KEY = TestCertificateStrings.readPrivateKey("sample_rp_signing_primary.pk8");
        TEST_RP_PUBLIC_ENCRYPTION_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.SAMPLE_RP_PUBLIC_ENCRYPTION_CERT);
        TEST_RP_PUBLIC_SIGNING_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.SAMPLE_RP_PUBLIC_SIGNING_CERT);
        TEST_RP_MS_PRIVATE_ENCRYPTION_KEY = TestCertificateStrings.readPrivateKey("sample_rp_msa_encryption_primary.pk8");
        TEST_RP_MS_PRIVATE_SIGNING_KEY = TestCertificateStrings.readPrivateKey("sample_rp_msa_signing_primary.pk8");
        TEST_RP_MS_PUBLIC_ENCRYPTION_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.SAMPLE_RP_MS_PUBLIC_ENCRYPTION_CERT);
        TEST_RP_MS_PUBLIC_SIGNING_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.SAMPLE_RP_MS_PUBLIC_SIGNING_CERT);
        HEADLESS_RP_PUBLIC_SIGNING_CERT = TEST_RP_PUBLIC_SIGNING_CERT;
        HEADLESS_RP_PRIVATE_SIGNING_KEY = TEST_RP_PRIVATE_SIGNING_KEY;
        HEADLESS_RP_MS_PUBLIC_SIGNING_CERT = TEST_RP_MS_PUBLIC_SIGNING_CERT;
        HEADLESS_RP_MS_PRIVATE_SIGNING_KEY = TEST_RP_MS_PRIVATE_SIGNING_KEY;
        HEADLESS_RP_MS_PRIVATE_ENCRYPTION_KEY = TEST_RP_MS_PRIVATE_ENCRYPTION_KEY;
        HEADLESS_RP_PUBLIC_ENCRYPTION_CERT = TEST_RP_PUBLIC_ENCRYPTION_CERT;
        HEADLESS_RP_MS_PUBLIC_ENCRYPTION_CERT = TEST_RP_MS_PUBLIC_ENCRYPTION_CERT;
        STUB_IDP_PUBLIC_PRIMARY_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_idp_signing_primary.pk8");
        STUB_IDP_PUBLIC_PRIMARY_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_IDP_PUBLIC_SIGNING_CERT);
        STUB_IDP_PUBLIC_SECONDARY_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_idp_signing_secondary.pk8");
        STUB_IDP_PUBLIC_SECONDARY_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_IDP_PUBLIC_SIGNING_SECONDARY_CERT);
        STUB_COUNTRY_PUBLIC_PRIMARY_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_country_signing_primary.pk8");
        STUB_COUNTRY_PUBLIC_PRIMARY_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_COUNTRY_PUBLIC_SIGNING_CERT);
        STUB_COUNTRY_PUBLIC_SECONDARY_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_country_signing_secondary.pk8");
        STUB_COUNTRY_PUBLIC_SECONDARY_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_COUNTRY_PUBLIC_SIGNING_SECONDARY_CERT);
        STUB_COUNTRY_PUBLIC_TERTIARY_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_country_signing_tertiary.pk8");
        STUB_COUNTRY_PUBLIC_TERTIARY_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_COUNTRY_PUBLIC_SIGNING_TERTIARY_CERT);
        STUB_COUNTRY_PUBLIC_EXPIRED_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_country_signing_expired.pk8");
        STUB_COUNTRY_PUBLIC_EXPIRED_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_COUNTRY_PUBLIC_SIGNING_EXPIRED_CERT);
        STUB_COUNTRY_PUBLIC_NOT_YET_VALID_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("stub_country_signing_not_yet_valid.pk8");
        STUB_COUNTRY_PUBLIC_NOT_YET_VALID_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.STUB_COUNTRY_PUBLIC_SIGNING_NOT_YET_VALID_CERT);
        METADATA_SIGNING_A_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("metadata_signing_a.pk8");
        METADATA_SIGNING_A_PUBLIC_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.METADATA_SIGNING_A_PUBLIC_CERT);
        METADATA_SIGNING_B_PRIVATE_KEY = TestCertificateStrings.readPrivateKey("metadata_signing_b.pk8");
        METADATA_SIGNING_B_PUBLIC_CERT = TestCertificateStrings.createInlineCertificate(PemCertificateStrings.METADATA_SIGNING_B_PUBLIC_CERT);
        PUBLIC_SIGNING_CERTS = ImmutableMap.builder().put((Object)TEST_ENTITY_ID, (Object)TEST_PUBLIC_CERT).put((Object)TEST_ENTITY_ID_EC, (Object)TEST_PUBLIC_EC_CERT).put((Object)"https://signin.service.gov.uk", (Object)HUB_TEST_PUBLIC_SIGNING_CERT).put((Object)"https://signin.service.gov.uk/secondary", (Object)HUB_TEST_SECONDARY_PUBLIC_SIGNING_CERT).put((Object)"https://signin.service.gov.uk/connector", (Object)HUB_CONNECTOR_TEST_PUBLIC_SIGNING_CERT).put((Object)"http://www.test-rp.gov.uk/SAML2/MD", (Object)TEST_RP_PUBLIC_SIGNING_CERT).put((Object)"http://www.test-rp-ms.gov.uk/SAML2/MD", (Object)TEST_RP_MS_PUBLIC_SIGNING_CERT).put((Object)"http://www.headless.gov.uk/SAML2/MD", (Object)HEADLESS_RP_PUBLIC_SIGNING_CERT).put((Object)"http://www.headless-ms.gov.uk/SAML2/MD", (Object)HEADLESS_RP_MS_PUBLIC_SIGNING_CERT).put((Object)"http://stub_idp.acme.org/stub-idp-one/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_CERT).put((Object)"http://stub_idp.acme.org/stub-idp-two/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_CERT).put((Object)"http://stub_idp.acme.org/stub-idp-three/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_CERT).put((Object)"http://stub_idp.acme.org/stub-idp-four/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_CERT).put((Object)"https://stub_country.acme.eu/stub-country-one/ServiceMetadata", (Object)STUB_COUNTRY_PUBLIC_PRIMARY_CERT).put((Object)"https://stub_country.acme.eu/stub-country-two/ServiceMetadata", (Object)STUB_COUNTRY_PUBLIC_PRIMARY_CERT).build();
        PRIVATE_SIGNING_KEYS = ImmutableMap.builder().put((Object)TEST_ENTITY_ID, (Object)TEST_PRIVATE_KEY).put((Object)TEST_ENTITY_ID_EC, (Object)TEST_PRIVATE_EC_KEY).put((Object)"https://signin.service.gov.uk", (Object)HUB_TEST_PRIVATE_SIGNING_KEY).put((Object)"https://signin.service.gov.uk/secondary", (Object)HUB_TEST_PRIVATE_SECONDARY_SIGNING_KEY).put((Object)"https://signin.service.gov.uk/connector", (Object)HUB_CONNECTOR_TEST_PRIVATE_SIGNING_KEY).put((Object)"http://www.test-rp.gov.uk/SAML2/MD", (Object)TEST_RP_PRIVATE_SIGNING_KEY).put((Object)"http://www.test-rp-ms.gov.uk/SAML2/MD", (Object)TEST_RP_MS_PRIVATE_SIGNING_KEY).put((Object)"http://www.headless.gov.uk/SAML2/MD", (Object)HEADLESS_RP_PRIVATE_SIGNING_KEY).put((Object)"http://www.headless-ms.gov.uk/SAML2/MD", (Object)HEADLESS_RP_MS_PRIVATE_SIGNING_KEY).put((Object)"http://stub_idp.acme.org/stub-idp-one/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_PRIVATE_KEY).put((Object)"http://stub_idp.acme.org/stub-idp-two/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_PRIVATE_KEY).put((Object)"http://stub_idp.acme.org/stub-idp-three/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_PRIVATE_KEY).put((Object)"http://stub_idp.acme.org/stub-idp-four/SSO/POST", (Object)STUB_IDP_PUBLIC_PRIMARY_PRIVATE_KEY).put((Object)"https://stub_country.acme.eu/stub-country-one/ServiceMetadata", (Object)STUB_COUNTRY_PUBLIC_PRIMARY_PRIVATE_KEY).put((Object)"https://stub_country.acme.eu/stub-country-two/ServiceMetadata", (Object)STUB_COUNTRY_PUBLIC_PRIMARY_PRIVATE_KEY).build();
        PUBLIC_ENCRYPTION_CERTS = ImmutableMap.builder().put((Object)TEST_ENTITY_ID, (Object)ImmutableList.of((Object)TEST_PUBLIC_CERT)).put((Object)TEST_ENTITY_ID_EC, (Object)ImmutableList.of((Object)TEST_PUBLIC_EC_CERT)).put((Object)"https://signin.service.gov.uk", (Object)ImmutableList.of((Object)HUB_TEST_PUBLIC_ENCRYPTION_CERT, (Object)TEST_PUBLIC_CERT)).put((Object)"https://signin.service.gov.uk/connector", (Object)ImmutableList.of((Object)HUB_CONNECTOR_TEST_PUBLIC_ENCRYPTION_CERT)).put((Object)"http://www.test-rp.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)TEST_RP_PUBLIC_ENCRYPTION_CERT)).put((Object)"http://www.test-rp-ms.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)TEST_RP_MS_PUBLIC_ENCRYPTION_CERT)).put((Object)"http://www.headless.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)HEADLESS_RP_PUBLIC_ENCRYPTION_CERT)).put((Object)"http://www.headless-ms.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)HEADLESS_RP_MS_PUBLIC_ENCRYPTION_CERT)).build();
        PRIVATE_ENCRYPTION_KEYS = ImmutableMap.builder().put((Object)TEST_ENTITY_ID, (Object)ImmutableList.of((Object)TEST_PRIVATE_KEY)).put((Object)TEST_ENTITY_ID_EC, (Object)ImmutableList.of((Object)TEST_PRIVATE_EC_KEY)).put((Object)"https://signin.service.gov.uk", (Object)ImmutableList.of((Object)HUB_TEST_PRIVATE_ENCRYPTION_KEY, (Object)TEST_PRIVATE_KEY)).put((Object)"https://signin.service.gov.uk/secondary", (Object)ImmutableList.of((Object)HUB_TEST_PRIVATE_ENCRYPTION_KEY, (Object)TEST_PRIVATE_KEY)).put((Object)"https://signin.service.gov.uk/connector", (Object)ImmutableList.of((Object)HUB_CONNECTOR_TEST_PRIVATE_ENCRYPTION_KEY)).put((Object)"http://www.test-rp.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)TEST_RP_PRIVATE_ENCRYPTION_KEY)).put((Object)"http://www.test-rp-ms.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)TEST_RP_MS_PRIVATE_ENCRYPTION_KEY)).put((Object)"http://www.headless.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)HEADLESS_RP_MS_PRIVATE_ENCRYPTION_KEY)).put((Object)"http://www.headless-ms.gov.uk/SAML2/MD", (Object)ImmutableList.of((Object)HEADLESS_RP_MS_PRIVATE_ENCRYPTION_KEY)).build();
    }
}

