/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.security.verification;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.PKIXParameters;
import uk.gov.ida.common.shared.security.verification.exceptions.CertificateChainValidationException;

public class PKIXParametersProvider {
    public PKIXParameters getPkixParameters(KeyStore keyStore) {
        PKIXParameters certPathParameters;
        try {
            certPathParameters = new PKIXParameters(keyStore);
        }
        catch (InvalidAlgorithmParameterException | KeyStoreException e) {
            throw new CertificateChainValidationException("There was an error reading from the trust store.", e);
        }
        certPathParameters.setRevocationEnabled(false);
        return certPathParameters;
    }
}

