/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.common.shared.security;

import java.util.ArrayList;
import java.util.List;
import uk.gov.ida.common.shared.configuration.DeserializablePublicKeyConfiguration;
import uk.gov.ida.common.shared.security.Certificate;

public class CertificateStore {
    private final List<DeserializablePublicKeyConfiguration> publicEncryptionKeyConfigurations;
    private final List<DeserializablePublicKeyConfiguration> publicSigningKeyConfigurations;

    public CertificateStore(List<DeserializablePublicKeyConfiguration> publicEncryptionKeyConfigurations, List<DeserializablePublicKeyConfiguration> publicSigningKeyConfiguration) {
        this.publicEncryptionKeyConfigurations = publicEncryptionKeyConfigurations;
        this.publicSigningKeyConfigurations = publicSigningKeyConfiguration;
    }

    public List<Certificate> getEncryptionCertificates() {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        for (DeserializablePublicKeyConfiguration certConfig : this.publicEncryptionKeyConfigurations) {
            certs.add(new Certificate(certConfig.getName(), this.stripHeaders(certConfig.getCert()), Certificate.KeyUse.Encryption));
        }
        return certs;
    }

    public List<Certificate> getSigningCertificates() {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        for (DeserializablePublicKeyConfiguration certConfig : this.publicSigningKeyConfigurations) {
            certs.add(new Certificate(certConfig.getName(), this.stripHeaders(certConfig.getCert()), Certificate.KeyUse.Signing));
        }
        return certs;
    }

    private String stripHeaders(String originalCertificate) {
        String strippedCertificate = originalCertificate;
        if (originalCertificate.contains("-----BEGIN CERTIFICATE-----")) {
            strippedCertificate = originalCertificate.replace("-----BEGIN CERTIFICATE-----", "");
        }
        if (originalCertificate.contains("-----END CERTIFICATE-----")) {
            strippedCertificate = strippedCertificate.replace("-----END CERTIFICATE-----", "");
        }
        return strippedCertificate.replace(" ", "");
    }
}

