/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import com.google.common.collect.ImmutableList;
import java.security.Key;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedElementType;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import uk.gov.ida.saml.security.SecretKeyEncrypter;
import uk.gov.ida.saml.security.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.security.exception.SamlFailedToDecryptException;
import uk.gov.ida.saml.security.validators.ValidatedEncryptedAssertionContainer;
import uk.gov.ida.saml.security.validators.encryptedelementtype.EncryptionAlgorithmValidator;

public class AssertionDecrypter {
    protected final EncryptionAlgorithmValidator encryptionAlgorithmValidator;
    private Decrypter decrypter;

    public AssertionDecrypter(EncryptionAlgorithmValidator encryptionAlgorithmValidator, Decrypter decrypter) {
        this.encryptionAlgorithmValidator = encryptionAlgorithmValidator;
        this.decrypter = decrypter;
    }

    public List<Assertion> decryptAssertions(ValidatedEncryptedAssertionContainer container) {
        List<EncryptedAssertion> encryptedAssertions = container.getEncryptedAssertions();
        ImmutableList.Builder assertions = ImmutableList.builder();
        if (encryptedAssertions.isEmpty()) {
            return assertions.build();
        }
        this.decrypter.setRootInNewDocument(true);
        for (EncryptedAssertion encryptedAssertion : encryptedAssertions) {
            try {
                this.encryptionAlgorithmValidator.validate((EncryptedElementType)encryptedAssertion);
                assertions.add((Object)this.decrypter.decrypt(encryptedAssertion));
            }
            catch (DecryptionException e) {
                String message = "Problem decrypting assertion " + encryptedAssertion + ".";
                throw new SamlFailedToDecryptException(SamlTransformationErrorFactory.unableToDecrypt(message), (Exception)((Object)e));
            }
        }
        return assertions.build();
    }

    public List<String> getReEncryptedKeys(ValidatedEncryptedAssertionContainer container, SecretKeyEncrypter secretKeyEncrypter, String entityId) {
        ArrayList<String> base64EncryptedKeys = new ArrayList<String>();
        String algorithm = "";
        for (EncryptedAssertion encryptedAssertion : container.getEncryptedAssertions()) {
            Iterator encryptedKeyIterator;
            if (encryptedAssertion.getEncryptedKeys().size() > 0) {
                encryptedKeyIterator = encryptedAssertion.getEncryptedKeys().iterator();
            } else if (encryptedAssertion.getEncryptedData().getKeyInfo().getEncryptedKeys().size() > 0) {
                encryptedKeyIterator = encryptedAssertion.getEncryptedData().getKeyInfo().getEncryptedKeys().iterator();
            } else {
                throw new SamlFailedToDecryptException(SamlTransformationErrorFactory.unableToLocateEncryptedKey());
            }
            Key decryptedKey = null;
            while (encryptedKeyIterator.hasNext() && decryptedKey == null) {
                try {
                    EncryptedKey encryptedKey = (EncryptedKey)encryptedKeyIterator.next();
                    algorithm = encryptedKey.getEncryptionMethod().getAlgorithm();
                    decryptedKey = this.decrypter.decryptKey(encryptedKey, algorithm);
                    base64EncryptedKeys.add(secretKeyEncrypter.encryptKeyForEntity(decryptedKey, entityId));
                }
                catch (DecryptionException e) {
                    if (encryptedKeyIterator.hasNext()) continue;
                    throw new SamlFailedToDecryptException(SamlTransformationErrorFactory.unableToDecryptXMLEncryptionKey(algorithm), (Exception)((Object)e));
                }
            }
        }
        return base64EncryptedKeys;
    }
}

