/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validators.subject;

import java.util.stream.Stream;
import org.opensaml.saml.saml2.core.Subject;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;

public class AssertionSubjectValidator {
    public void validate(Subject subject, String assertionId) {
        if (subject == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingAssertionSubject(assertionId);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (subject.getNameID() == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.assertionSubjectHasNoNameID(assertionId);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (subject.getNameID().getFormat() == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingAssertionSubjectNameIDFormat(assertionId);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        boolean correctNameIdType = Stream.of("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient").anyMatch(type -> type.equals(subject.getNameID().getFormat()));
        if (!correctNameIdType) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.illegalAssertionSubjectNameIDFormat(assertionId, subject.getNameID().getFormat());
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

