/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.util.encoders.Base64;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import uk.gov.ida.saml.security.IdaKeyStoreCredentialRetriever;

public class SecretKeyDecryptorFactory {
    private final IdaKeyStoreCredentialRetriever idaKeyStoreCredentialRetriever;

    public SecretKeyDecryptorFactory(IdaKeyStoreCredentialRetriever idaKeyStoreCredentialRetriever) {
        this.idaKeyStoreCredentialRetriever = idaKeyStoreCredentialRetriever;
    }

    public Decrypter createDecrypter(String encryptedSecretKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        List<Credential> decryptingCredentials = this.idaKeyStoreCredentialRetriever.getDecryptingCredentials();
        PrivateKey privateKey = decryptingCredentials.get(0).getPrivateKey();
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(4, privateKey);
        SecretKey transientKey = (SecretKey)cipher.unwrap(Base64.decode((String)encryptedSecretKey), cipher.getAlgorithm(), 3);
        BasicCredential basicCredential = new BasicCredential(transientKey);
        StaticKeyInfoCredentialResolver keyResolver = new StaticKeyInfoCredentialResolver((Credential)basicCredential);
        return new Decrypter((KeyInfoCredentialResolver)keyResolver, null, null);
    }
}

