/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.factories;

import com.google.common.base.Throwables;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.inject.Provider;
import uk.gov.ida.saml.metadata.KeyStoreLoader;
import uk.gov.ida.saml.metadata.exception.EmptyTrustStoreException;

public class MetadataTrustStoreProvider
implements Provider<KeyStore> {
    private KeyStoreLoader keyStoreLoader;
    private String uri;
    private String password;

    public MetadataTrustStoreProvider(KeyStoreLoader keyStoreLoader, String uri, String password) {
        this.keyStoreLoader = keyStoreLoader;
        this.uri = uri;
        this.password = password;
    }

    public KeyStore get() {
        KeyStore trustStore = this.keyStoreLoader.load(this.uri, this.password);
        int trustStoreSize = 0;
        try {
            trustStoreSize = trustStore.size();
        }
        catch (KeyStoreException e) {
            Throwables.propagate((Throwable)e);
        }
        if (trustStoreSize == 0) {
            throw new EmptyTrustStoreException();
        }
        return trustStore;
    }
}

