/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.bundle;

import com.codahale.metrics.health.HealthCheck;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Provider;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import uk.gov.ida.saml.metadata.MetadataHealthCheck;
import uk.gov.ida.saml.metadata.MetadataResolverConfiguration;
import uk.gov.ida.saml.metadata.exception.MetadataResolverCreationException;
import uk.gov.ida.saml.metadata.factories.CredentialResolverFactory;
import uk.gov.ida.saml.metadata.factories.DropwizardMetadataResolverFactory;
import uk.gov.ida.saml.metadata.factories.MetadataSignatureTrustEngineFactory;

public class MetadataResolverBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private final MetadataConfigurationExtractor<T> configExtractor;
    private MetadataResolver metadataResolver;
    private DropwizardMetadataResolverFactory dropwizardMetadataResolverFactory = new DropwizardMetadataResolverFactory();
    private ExplicitKeySignatureTrustEngine signatureTrustEngine;
    private MetadataCredentialResolver credentialResolver;
    private final boolean validateSignatures;

    public MetadataResolverBundle(MetadataConfigurationExtractor<T> configExtractor) {
        this(configExtractor, true);
    }

    public MetadataResolverBundle(MetadataConfigurationExtractor<T> configExtractor, boolean validateSignatures) {
        this.configExtractor = configExtractor;
        this.validateSignatures = validateSignatures;
    }

    public void run(T configuration, Environment environment) throws Exception {
        this.configExtractor.getMetadataConfiguration(configuration).ifPresent(mc -> {
            this.metadataResolver = this.dropwizardMetadataResolverFactory.createMetadataResolver(environment, (MetadataResolverConfiguration)mc, this.validateSignatures);
            try {
                this.signatureTrustEngine = new MetadataSignatureTrustEngineFactory().createSignatureTrustEngine(this.metadataResolver);
                this.credentialResolver = new CredentialResolverFactory().create(this.metadataResolver);
            }
            catch (ComponentInitializationException e) {
                throw new MetadataResolverCreationException(mc.getUri(), e.getMessage());
            }
            MetadataHealthCheck healthCheck = new MetadataHealthCheck(this.metadataResolver, mc.getExpectedEntityId());
            environment.healthChecks().register(mc.getUri().toString(), (HealthCheck)healthCheck);
        });
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Nullable
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    public Provider<MetadataResolver> getMetadataResolverProvider() {
        return () -> this.metadataResolver;
    }

    @Nullable
    public ExplicitKeySignatureTrustEngine getSignatureTrustEngine() {
        return this.signatureTrustEngine;
    }

    public Provider<ExplicitKeySignatureTrustEngine> getSignatureTrustEngineProvider() {
        return () -> this.signatureTrustEngine;
    }

    @Nullable
    public MetadataCredentialResolver getMetadataCredentialResolver() {
        return this.credentialResolver;
    }

    public Provider<MetadataCredentialResolver> getMetadataCredentialResolverProvider() {
        return () -> this.credentialResolver;
    }

    public Module getMetadataModule() {
        return binder -> binder.bind(MetadataResolver.class).toProvider(this.getMetadataResolverProvider());
    }

    public static interface MetadataConfigurationExtractor<T> {
        public Optional<MetadataResolverConfiguration> getMetadataConfiguration(T var1);
    }
}

