/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validation.subjectconfirmation;

import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;

public class BasicAssertionSubjectConfirmationValidator {
    public void validate(SubjectConfirmation subjectConfirmation) {
        SubjectConfirmationData subjectConfirmationData = subjectConfirmation.getSubjectConfirmationData();
        if (subjectConfirmationData == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingSubjectConfirmationData();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (subjectConfirmationData.getInResponseTo() == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingBearerInResponseTo();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (subjectConfirmationData.getRecipient() == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingBearerRecipient();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        DateTime notOnOrAfter = subjectConfirmationData.getNotOnOrAfter();
        if (notOnOrAfter == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingNotOnOrAfter();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        DateTime now = DateTime.now();
        if (notOnOrAfter.isEqual((ReadableInstant)now) || notOnOrAfter.isBefore((ReadableInstant)now)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.exceededNotOnOrAfter(notOnOrAfter);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (subjectConfirmationData.getNotBefore() != null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.notBeforeExists();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

