/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.outbound;

import java.util.function.Function;
import javax.inject.Inject;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.IdaResponse;

public abstract class IdaResponseToSamlResponseTransformer<TInput extends IdaResponse>
implements Function<TInput, Response> {
    private final OpenSamlXmlObjectFactory openSamlXmlObjectFactory;

    @Inject
    public IdaResponseToSamlResponseTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
    }

    @Override
    public Response apply(TInput originalResponse) {
        Response transformedResponse = this.openSamlXmlObjectFactory.createResponse();
        transformedResponse.setID(originalResponse.getId());
        transformedResponse.setIssueInstant(originalResponse.getIssueInstant());
        transformedResponse.setInResponseTo(originalResponse.getInResponseTo());
        this.transformIssuer(originalResponse, transformedResponse);
        this.transformDestination(originalResponse, transformedResponse);
        this.transformAssertions(originalResponse, transformedResponse);
        transformedResponse.setStatus(this.transformStatus(originalResponse));
        return transformedResponse;
    }

    protected void transformIssuer(TInput originalResponse, Response transformedResponse) {
        Issuer issuer = this.openSamlXmlObjectFactory.createIssuer(originalResponse.getIssuer());
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        transformedResponse.setIssuer(issuer);
    }

    protected abstract void transformAssertions(TInput var1, Response var2);

    protected abstract Status transformStatus(TInput var1);

    protected abstract void transformDestination(TInput var1, Response var2);
}

