/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDate;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import uk.gov.ida.saml.core.domain.MatchingDataset;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.extensions.StringBasedMdsAttributeValue;
import uk.gov.ida.saml.core.transformers.MatchingDatasetBuilder;

public abstract class MatchingDatasetUnmarshaller {
    public MatchingDataset fromAssertion(Assertion assertion) {
        List attributeStatements = assertion.getAttributeStatements();
        if (attributeStatements.isEmpty()) {
            return null;
        }
        List attributes = ((AttributeStatement)attributeStatements.get(0)).getAttributes();
        MatchingDatasetBuilder datasetBuilder = new MatchingDatasetBuilder();
        for (Attribute attribute : attributes) {
            this.transformAttribute(attribute, datasetBuilder);
        }
        datasetBuilder.personalId(this.getPersonalIdentifier(assertion));
        return datasetBuilder.build();
    }

    protected abstract void transformAttribute(Attribute var1, MatchingDatasetBuilder var2);

    protected abstract String getPersonalIdentifier(Assertion var1);

    final List<SimpleMdsValue<LocalDate>> getBirthDates(Attribute attribute) {
        ArrayList<SimpleMdsValue<LocalDate>> birthDates = new ArrayList<SimpleMdsValue<LocalDate>>();
        for (XMLObject xmlObject : attribute.getAttributeValues()) {
            StringBasedMdsAttributeValue stringBasedMdsAttributeValue = (StringBasedMdsAttributeValue)xmlObject;
            String dateOfBirthString = stringBasedMdsAttributeValue.getValue();
            birthDates.add(new SimpleMdsValue<LocalDate>(LocalDate.parse((String)dateOfBirthString), stringBasedMdsAttributeValue.getFrom(), stringBasedMdsAttributeValue.getTo(), stringBasedMdsAttributeValue.getVerified()));
        }
        return birthDates;
    }
}

