/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.outbound;

import javax.inject.Inject;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.AssertionRestrictions;
import uk.gov.ida.saml.core.domain.OutboundAssertion;

public class OutboundAssertionToSubjectTransformer {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory;

    @Inject
    public OutboundAssertionToSubjectTransformer(OpenSamlXmlObjectFactory openSamlXmlObjectFactory) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
    }

    public Subject transform(OutboundAssertion originalAssertion) {
        Subject subject = this.openSamlXmlObjectFactory.createSubject();
        NameID nameId = this.openSamlXmlObjectFactory.createNameId(originalAssertion.getPersistentId().getNameId());
        nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        subject.setNameID(nameId);
        SubjectConfirmation subjectConfirmation = this.openSamlXmlObjectFactory.createSubjectConfirmation();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SubjectConfirmationData subjectConfirmationData = this.openSamlXmlObjectFactory.createSubjectConfirmationData();
        AssertionRestrictions assertionRestrictions = originalAssertion.getAssertionRestrictions();
        subjectConfirmationData.setNotOnOrAfter(assertionRestrictions.getNotOnOrAfter());
        subjectConfirmationData.setInResponseTo(assertionRestrictions.getInResponseTo());
        subjectConfirmationData.setRecipient(assertionRestrictions.getRecipient());
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }
}

