/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import uk.gov.ida.saml.security.IdaKeyStore;

public class IdaKeyStoreCredentialRetriever {
    private final IdaKeyStore keyStore;

    public IdaKeyStoreCredentialRetriever(IdaKeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public Credential getSigningCredential() {
        UsageType usageType = UsageType.SIGNING;
        KeyPair keyPair = this.keyStore.getSigningKeyPair();
        BasicCredential credential = this.buildCredential(keyPair.getPublic(), keyPair.getPrivate(), usageType);
        return credential;
    }

    public X509Certificate getSigningCertificate() {
        return this.keyStore.getSigningCertificate();
    }

    public List<Credential> getDecryptingCredentials() {
        return this.getCredentials(UsageType.ENCRYPTION, this.keyStore.getEncryptionKeyPairs());
    }

    private List<Credential> getCredentials(UsageType usageType, List<KeyPair> keyPairs) {
        return keyPairs.stream().map(keyPair -> this.buildCredential(keyPair.getPublic(), keyPair.getPrivate(), usageType)).collect(Collectors.toList());
    }

    private BasicCredential buildCredential(PublicKey publicKey, PrivateKey privateKey, UsageType usageType) {
        BasicCredential credential = new BasicCredential(publicKey, privateKey);
        credential.setUsageType(usageType);
        return credential;
    }
}

