/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NonMatchingVerifiableAttribute<T> {
    private final T value;
    private final boolean verified;
    private final LocalDate from;
    private final LocalDate to;

    @JsonCreator
    public NonMatchingVerifiableAttribute(@JsonProperty(value="value") T value, @JsonProperty(value="verified") boolean verified, @JsonProperty(value="from") @JsonInclude(value=JsonInclude.Include.NON_NULL) LocalDate from, @JsonProperty(value="to") @JsonInclude(value=JsonInclude.Include.NON_NULL) LocalDate to) {
        this.value = value;
        this.verified = verified;
        this.from = from;
        this.to = to;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public boolean isValid() {
        return this.verified && this.isCurrent() && this.value != null;
    }

    public boolean isCurrent() {
        return !(this.from != null && !this.from.isBefore(LocalDate.now()) || this.to != null && !this.to.isAfter(LocalDate.now()));
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public LocalDate getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonMatchingVerifiableAttribute that = (NonMatchingVerifiableAttribute)o;
        return this.isVerified() == that.isVerified() && this.getValue().equals(that.getValue()) && this.getFrom().equals(that.getFrom()) && this.getTo().equals(that.getTo());
    }

    public int hashCode() {
        int result = this.getValue().hashCode();
        result = 31 * result + (this.isVerified() ? 1 : 0);
        result = 31 * result + this.getFrom().hashCode();
        result = 31 * result + this.getTo().hashCode();
        return result;
    }

    public String toString() {
        return String.format("NonMatchingVerifiableAttribute{ value=%s, verified=%s, from=%s, to=%s }", this.value, this.verified, this.from, this.to);
    }
}

