/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.transformers.outbound;

import com.google.inject.Inject;
import java.util.function.Function;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.w3c.dom.Element;
import uk.gov.ida.saml.core.domain.SamlAttributeQueryAssertionEncrypter;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlSignatureSigner;
import uk.gov.ida.saml.hub.transformers.outbound.SamlAttributeQueryAssertionSignatureSigner;
import uk.gov.ida.saml.hub.transformers.outbound.SigningRequestAbstractTypeSignatureCreator;
import uk.gov.ida.saml.serializers.XmlObjectToElementTransformer;

public class AttributeQueryToElementTransformer
implements Function<AttributeQuery, Element> {
    private final SigningRequestAbstractTypeSignatureCreator<AttributeQuery> signatureCreator;
    private final SamlAttributeQueryAssertionSignatureSigner samlAttributeQueryAssertionSignatureSigner;
    private final SamlSignatureSigner<AttributeQuery> samlSignatureSigner;
    private final XmlObjectToElementTransformer<AttributeQuery> xmlObjectToElementTransformer;
    private final SamlAttributeQueryAssertionEncrypter encrypter;

    @Inject
    public AttributeQueryToElementTransformer(SigningRequestAbstractTypeSignatureCreator<AttributeQuery> signatureCreator, SamlAttributeQueryAssertionSignatureSigner samlAttributeQueryAssertionSignatureSigner, SamlSignatureSigner<AttributeQuery> samlSignatureSigner, XmlObjectToElementTransformer<AttributeQuery> xmlObjectToElementTransformer, SamlAttributeQueryAssertionEncrypter encrypter) {
        this.signatureCreator = signatureCreator;
        this.samlSignatureSigner = samlSignatureSigner;
        this.samlAttributeQueryAssertionSignatureSigner = samlAttributeQueryAssertionSignatureSigner;
        this.xmlObjectToElementTransformer = xmlObjectToElementTransformer;
        this.encrypter = encrypter;
    }

    @Override
    public Element apply(AttributeQuery attributeQuery) {
        AttributeQuery queryWithSignature = this.signatureCreator.addUnsignedSignatureTo(attributeQuery);
        AttributeQuery queryWithSignedAssertions = this.samlAttributeQueryAssertionSignatureSigner.signAssertions(queryWithSignature);
        AttributeQuery queryWithEncryptedAssertions = this.encrypter.encryptAssertions(queryWithSignedAssertions);
        AttributeQuery signedQuery = this.samlSignatureSigner.sign(queryWithEncryptedAssertions);
        return this.xmlObjectToElementTransformer.apply(signedQuery);
    }
}

