/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validation.assertion;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.extensions.IdpFraudEventId;
import uk.gov.ida.saml.core.extensions.PersonName;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;

public class AssertionAttributeStatementValidator {
    public static final String INVALID_FRAUD_EVENT_TYPE = "Invalid fraud event type";
    private static final String INVALID_FRAUD_EVENT_NAME = "Invalid fraud event name";
    private static final String INVALID_NUMBER_OF_FRAUD_EVENT_ATTRIBUTE_STATEMENTS = "Invalid number of fraud event attribute statements";

    public void validate(Assertion assertion) {
        for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                for (XMLObject attributeValue : attribute.getAttributeValues()) {
                    PersonName personName;
                    String language;
                    if (!(attributeValue instanceof PersonName) || (language = (personName = (PersonName)attributeValue).getLanguage()) == null || "en-GB".equals(language)) continue;
                    SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidAttributeLanguageInAssertion(attribute.getName(), language);
                    throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
                }
            }
        }
    }

    public void validateFraudEvent(Assertion assertion) {
        if (assertion.getAttributeStatements().size() != 1) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidFraudAttribute(INVALID_NUMBER_OF_FRAUD_EVENT_ATTRIBUTE_STATEMENTS);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        AttributeStatement attributeStatement = (AttributeStatement)assertion.getAttributeStatements().get(0);
        this.validateFraudEvent(attributeStatement);
    }

    private void validateFraudEvent(AttributeStatement attributeStatement) {
        boolean didNotDeserializeCorrectlyIntoFraudEventType;
        Attribute fraudEventAttribute = (Attribute)Iterables.find((Iterable)attributeStatement.getAttributes(), (Predicate)new Predicate<Attribute>(){

            public boolean apply(Attribute input) {
                return input.getName().equals("FECI_IDPFraudEventID");
            }
        }, null);
        if (fraudEventAttribute == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidFraudAttribute(INVALID_FRAUD_EVENT_NAME);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        boolean bl = didNotDeserializeCorrectlyIntoFraudEventType = !(fraudEventAttribute.getAttributeValues().get(0) instanceof IdpFraudEventId);
        if (didNotDeserializeCorrectlyIntoFraudEventType) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidFraudAttribute(INVALID_FRAUD_EVENT_TYPE);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

