/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.outbound.decorators;

import com.google.common.base.Throwables;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import uk.gov.ida.saml.security.EncrypterFactory;
import uk.gov.ida.saml.security.KeyStoreBackedEncryptionCredentialResolver;

public class AssertionEncrypter {
    private final KeyStoreBackedEncryptionCredentialResolver credentialFactory;
    private final EncrypterFactory encrypterFactory;

    public AssertionEncrypter(EncrypterFactory encrypterFactory, KeyStoreBackedEncryptionCredentialResolver credentialFactory) {
        this.encrypterFactory = encrypterFactory;
        this.credentialFactory = credentialFactory;
    }

    public EncryptedAssertion encrypt(Assertion assertion, String entityId) {
        Credential encryptingCredential = this.credentialFactory.getEncryptingCredential(entityId);
        Encrypter encrypter = this.encrypterFactory.createEncrypter(encryptingCredential);
        try {
            return encrypter.encrypt(assertion);
        }
        catch (EncryptionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

