/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import uk.gov.ida.saml.core.domain.Address;
import uk.gov.ida.saml.core.extensions.Line;

public class AddressFactory {
    public Address create(List<String> lines, String postCode, String internationalPostCode, String uprn, DateTime from, DateTime to, boolean isVerified) {
        return new Address(lines, postCode, internationalPostCode, uprn, from, to, isVerified);
    }

    public List<Address> create(Attribute attribute) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        for (XMLObject xmlObject : attribute.getAttributeValues()) {
            uk.gov.ida.saml.core.extensions.Address address = (uk.gov.ida.saml.core.extensions.Address)xmlObject;
            addresses.add(this.create(address));
        }
        return addresses;
    }

    public Address create(uk.gov.ida.saml.core.extensions.Address addressAttributeValue) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Line originalLine : addressAttributeValue.getLines()) {
            lines.add(originalLine.getValue());
        }
        DateTime toDate = addressAttributeValue.getTo();
        DateTime fromDate = addressAttributeValue.getFrom();
        String postCodeString = null;
        if (addressAttributeValue.getPostCode() != null) {
            postCodeString = addressAttributeValue.getPostCode().getValue();
        }
        String internationalPostCodeString = null;
        if (addressAttributeValue.getInternationalPostCode() != null) {
            internationalPostCodeString = addressAttributeValue.getInternationalPostCode().getValue();
        }
        String uprnString = null;
        if (addressAttributeValue.getUPRN() != null) {
            uprnString = addressAttributeValue.getUPRN().getValue();
        }
        return new Address(lines, postCodeString, internationalPostCodeString, uprnString, fromDate, toDate, addressAttributeValue.getVerified());
    }
}

