/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidationParametersCriterion;

public abstract class SignatureValidator {
    private final SAMLSignatureProfileValidator samlSignatureProfileValidator = new SAMLSignatureProfileValidator();

    public final boolean validate(SignableSAMLObject signableSAMLObject, String entityId, QName role) throws SecurityException, SignatureException {
        Signature signature = signableSAMLObject.getSignature();
        if (signature == null) {
            throw new SignatureException("Signature in signableSAMLObject is null");
        }
        this.samlSignatureProfileValidator.validate(signature);
        List<Criterion> additionalCriteria = this.getAdditionalCriteria(entityId, role);
        CriteriaSet criteria = new CriteriaSet();
        SignatureValidationParameters signatureValidationParameters = new SignatureValidationParameters();
        signatureValidationParameters.setWhitelistedAlgorithms(Arrays.asList("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmlenc#sha512", "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256"));
        criteria.add((Object)new SignatureValidationParametersCriterion(signatureValidationParameters));
        criteria.addAll(additionalCriteria);
        return this.getTrustEngine(entityId).validate((Object)signableSAMLObject.getSignature(), criteria);
    }

    protected abstract TrustEngine<Signature> getTrustEngine(String var1);

    protected abstract List<Criterion> getAdditionalCriteria(String var1, QName var2);
}

