/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.validation.assertion;

import java.util.Arrays;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.core.errors.SamlTransformationErrorFactory;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.assertion.AssertionAttributeStatementValidator;
import uk.gov.ida.saml.core.validation.assertion.AssertionValidator;
import uk.gov.ida.saml.core.validation.subjectconfirmation.AssertionSubjectConfirmationValidator;
import uk.gov.ida.saml.core.validators.subject.AssertionSubjectValidator;
import uk.gov.ida.saml.security.validators.issuer.IssuerValidator;

public class IdentityProviderAssertionValidator
extends AssertionValidator {
    private final AssertionSubjectConfirmationValidator subjectConfirmationValidator;

    public IdentityProviderAssertionValidator(IssuerValidator issuerValidator, AssertionSubjectValidator subjectValidator, AssertionAttributeStatementValidator assertionAttributeStatementValidator, AssertionSubjectConfirmationValidator subjectConfirmationValidator) {
        super(issuerValidator, subjectValidator, assertionAttributeStatementValidator, subjectConfirmationValidator);
        this.subjectConfirmationValidator = subjectConfirmationValidator;
    }

    public void validateConsistency(Assertion authnStatementAssertion, Assertion matchingDatasetAssertion) {
        this.validateConsistency(Arrays.asList(authnStatementAssertion, matchingDatasetAssertion));
    }

    public void validateConsistency(List<Assertion> assertions) {
        this.ensurePidsMatch(assertions);
        this.ensureIssuersMatch(assertions);
    }

    private void ensurePidsMatch(List<Assertion> assertions) {
        boolean pidsDoNotMatch;
        boolean bl = pidsDoNotMatch = assertions.stream().map(assertion -> assertion.getSubject().getNameID().getValue()).distinct().count() > 1L;
        if (pidsDoNotMatch) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.mismatchedPersistentIdentifiers();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void ensureIssuersMatch(List<Assertion> assertions) {
        boolean issuerValuesDoNotMatch;
        boolean bl = issuerValuesDoNotMatch = assertions.stream().map(assertion -> assertion.getIssuer().getValue()).distinct().count() > 1L;
        if (issuerValuesDoNotMatch) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.mismatchedIssuers();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    @Override
    public void validateSubject(Assertion assertion, String requestId, String expectedRecipientId) {
        super.validateSubject(assertion, requestId, expectedRecipientId);
        this.ensurePresenceOfBearerSubjectConfirmation(assertion);
        this.validateAllBearerSubjectConfirmations(assertion, requestId, expectedRecipientId);
        this.validateFraudAttribute(assertion);
    }

    private void validateAllBearerSubjectConfirmations(Assertion assertion, String requestId, String expectedRecipientId) {
        for (SubjectConfirmation subjectConfirmation : assertion.getSubject().getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())) continue;
            this.subjectConfirmationValidator.validate(subjectConfirmation, requestId, expectedRecipientId);
        }
    }

    private void ensurePresenceOfBearerSubjectConfirmation(Assertion assertion) {
        boolean hasSubjectConfirmationWithBearerMethod = false;
        for (SubjectConfirmation subjectConfirmation : assertion.getSubject().getSubjectConfirmations()) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation.getMethod())) continue;
            hasSubjectConfirmationWithBearerMethod = true;
        }
        if (!hasSubjectConfirmationWithBearerMethod) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.noSubjectConfirmationWithBearerMethod(assertion.getID());
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }

    private void validateFraudAttribute(Assertion assertion) {
        AuthnStatement authnStatement;
        boolean isFraudResponse;
        if (assertion.getAuthnStatements().size() == 1 && (isFraudResponse = (authnStatement = (AuthnStatement)assertion.getAuthnStatements().get(0)).getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef().equals(AuthnContext.LEVEL_X.getUri()))) {
            this.assertionAttributeStatementValidator.validateFraudEvent(assertion);
        }
    }
}

