/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers;

import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import uk.gov.ida.saml.core.domain.Address;
import uk.gov.ida.saml.core.domain.MatchingDataset;
import uk.gov.ida.saml.core.domain.NonMatchingAddress;
import uk.gov.ida.saml.core.domain.NonMatchingAttributes;
import uk.gov.ida.saml.core.domain.NonMatchingTransliterableAttribute;
import uk.gov.ida.saml.core.domain.NonMatchingVerifiableAttribute;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.domain.TransliterableMdsValue;

public class MatchingDatasetToNonMatchingAttributesMapper {
    public NonMatchingAttributes mapToNonMatchingAttributes(MatchingDataset matchingDataset) {
        List<NonMatchingTransliterableAttribute> firstNames = this.convertTransliterableNameAttributes(matchingDataset.getFirstNames());
        List<NonMatchingVerifiableAttribute<LocalDate>> datesOfBirth = this.convertDateOfBirths(matchingDataset.getDateOfBirths());
        List<NonMatchingVerifiableAttribute<String>> middleNames = this.convertNameAttributes(matchingDataset.getMiddleNames());
        List<NonMatchingTransliterableAttribute> surnames = this.convertTransliterableNameAttributes(matchingDataset.getSurnames());
        NonMatchingVerifiableAttribute gender = matchingDataset.getGender().map(this::mapToNonMatchingVerifiableAttribute).orElse(null);
        List<NonMatchingVerifiableAttribute<NonMatchingAddress>> addresses = this.mapAddresses(matchingDataset.getAddresses());
        return new NonMatchingAttributes(firstNames, middleNames, surnames, datesOfBirth, gender, addresses);
    }

    public static <T> Comparator<NonMatchingVerifiableAttribute<T>> attributeComparator() {
        return Comparator.comparing(NonMatchingVerifiableAttribute::getTo, Comparator.nullsFirst(Comparator.reverseOrder())).thenComparing(NonMatchingVerifiableAttribute::isVerified, Comparator.reverseOrder()).thenComparing(NonMatchingVerifiableAttribute::getFrom, Comparator.nullsLast(Comparator.reverseOrder()));
    }

    private List<NonMatchingVerifiableAttribute<String>> convertNameAttributes(List<SimpleMdsValue<String>> values) {
        return values.stream().map(this::mapToNonMatchingVerifiableAttribute).sorted(MatchingDatasetToNonMatchingAttributesMapper.attributeComparator()).collect(Collectors.toList());
    }

    private List<NonMatchingVerifiableAttribute<LocalDate>> convertDateOfBirths(List<SimpleMdsValue<org.joda.time.LocalDate>> values) {
        return values.stream().map(MatchingDatasetToNonMatchingAttributesMapper::convertWrappedJodaLocalDateToJavaLocalDate).map(this::mapToNonMatchingVerifiableAttribute).sorted(MatchingDatasetToNonMatchingAttributesMapper.attributeComparator()).collect(Collectors.toList());
    }

    private List<NonMatchingTransliterableAttribute> convertTransliterableNameAttributes(List<TransliterableMdsValue> values) {
        return values.stream().map(this::mapToTransliterableAttribute).sorted(MatchingDatasetToNonMatchingAttributesMapper.attributeComparator()).collect(Collectors.toList());
    }

    private NonMatchingTransliterableAttribute mapToTransliterableAttribute(TransliterableMdsValue transliterableMdsValue) {
        LocalDate from = Optional.ofNullable(transliterableMdsValue.getFrom()).map(MatchingDatasetToNonMatchingAttributesMapper::convertJodaDateTimeToJavaLocalDate).orElse(null);
        LocalDate to = Optional.ofNullable(transliterableMdsValue.getTo()).map(MatchingDatasetToNonMatchingAttributesMapper::convertJodaDateTimeToJavaLocalDate).orElse(null);
        return new NonMatchingTransliterableAttribute((String)transliterableMdsValue.getValue(), transliterableMdsValue.getNonLatinScriptValue(), transliterableMdsValue.isVerified(), from, to);
    }

    private <T> NonMatchingVerifiableAttribute<T> mapToNonMatchingVerifiableAttribute(SimpleMdsValue<T> simpleMdsValueOptional) {
        LocalDate from = Optional.ofNullable(simpleMdsValueOptional.getFrom()).map(MatchingDatasetToNonMatchingAttributesMapper::convertJodaDateTimeToJavaLocalDate).orElse(null);
        LocalDate to = Optional.ofNullable(simpleMdsValueOptional.getTo()).map(MatchingDatasetToNonMatchingAttributesMapper::convertJodaDateTimeToJavaLocalDate).orElse(null);
        return new NonMatchingVerifiableAttribute<T>(simpleMdsValueOptional.getValue(), simpleMdsValueOptional.isVerified(), from, to);
    }

    private List<NonMatchingVerifiableAttribute<NonMatchingAddress>> mapAddresses(List<Address> addresses) {
        return addresses.stream().map(this::mapAddress).sorted(MatchingDatasetToNonMatchingAttributesMapper.attributeComparator()).collect(Collectors.toList());
    }

    private NonMatchingVerifiableAttribute<NonMatchingAddress> mapAddress(Address input) {
        NonMatchingAddress transformedAddress = new NonMatchingAddress(input.getLines(), input.getPostCode().orElse(null), input.getInternationalPostCode().orElse(null), input.getUPRN().orElse(null));
        LocalDate from = Optional.ofNullable(input.getFrom()).map(MatchingDatasetToNonMatchingAttributesMapper::convertJodaDateTimeToJavaLocalDate).orElse(null);
        LocalDate to = input.getTo().map(MatchingDatasetToNonMatchingAttributesMapper::convertJodaDateTimeToJavaLocalDate).orElse(null);
        return new NonMatchingVerifiableAttribute<NonMatchingAddress>(transformedAddress, input.isVerified(), from, to);
    }

    private static LocalDate convertJodaDateTimeToJavaLocalDate(DateTime jodaDateTime) {
        return LocalDate.of(jodaDateTime.getYear(), jodaDateTime.getMonthOfYear(), jodaDateTime.getDayOfMonth());
    }

    private static LocalDate convertJodaLocalDateToJavaLocalDate(org.joda.time.LocalDate jodaDate) {
        return LocalDate.of(jodaDate.getYear(), jodaDate.getMonthOfYear(), jodaDate.getDayOfMonth());
    }

    private static SimpleMdsValue<LocalDate> convertWrappedJodaLocalDateToJavaLocalDate(SimpleMdsValue<org.joda.time.LocalDate> wrappedJodaDate) {
        LocalDate javaLocalDate = MatchingDatasetToNonMatchingAttributesMapper.convertJodaLocalDateToJavaLocalDate(wrappedJodaDate.getValue());
        return new SimpleMdsValue<LocalDate>(javaLocalDate, wrappedJodaDate.getFrom(), wrappedJodaDate.getTo(), wrappedJodaDate.isVerified());
    }
}

