/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.factories;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Optional;
import org.apache.commons.codec.binary.Hex;
import uk.gov.ida.saml.core.domain.AuthnContext;

public class UserIdHashFactory {
    private final String hashingEntityId;

    public UserIdHashFactory(String hashingEntityId) {
        this.hashingEntityId = hashingEntityId;
    }

    public String hashId(String issuerEntityId, String persistentId, Optional<AuthnContext> authnContext) {
        return UserIdHashFactory.hashId(this.hashingEntityId, issuerEntityId, persistentId, authnContext);
    }

    public static String hashId(String hashingEntityId, String issuerEntityId, String persistentId, Optional<AuthnContext> authnContext) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String toHash = UserIdHashFactory.idToHash(hashingEntityId, issuerEntityId, persistentId, authnContext);
        try {
            messageDigest.update(toHash.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = messageDigest.digest();
        return Hex.encodeHexString((byte[])digest);
    }

    private static String idToHash(String hashingEntityId, String issuerEntityId, String persistentId, Optional<AuthnContext> context) {
        AuthnContext authnContext = context.orElseThrow(() -> new AuthnContextMissingException(String.format("Authn context absent for persistent id %s", persistentId)));
        String persistentIdHash = authnContext.equals((Object)AuthnContext.LEVEL_2) ? MessageFormat.format("{0}{1}{2}", issuerEntityId, hashingEntityId, persistentId) : MessageFormat.format("{0}{1}{2}{3}", issuerEntityId, hashingEntityId, persistentId, authnContext.name());
        return persistentIdHash;
    }

    static class AuthnContextMissingException
    extends RuntimeException {
        AuthnContextMissingException(String message) {
            super(message);
        }
    }
}

