/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.outbound;

import java.util.function.Function;
import javax.inject.Inject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Response;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseAssertionSigner;
import uk.gov.ida.saml.core.transformers.outbound.decorators.ResponseSignatureCreator;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlResponseAssertionEncrypter;
import uk.gov.ida.saml.core.transformers.outbound.decorators.SamlSignatureSigner;
import uk.gov.ida.saml.serializers.XmlObjectToBase64EncodedStringTransformer;

public class ResponseToSignedStringTransformer
implements Function<Response, String> {
    protected final XmlObjectToBase64EncodedStringTransformer<?> xmlObjectToBase64EncodedStringTransformer;
    protected final SamlSignatureSigner<Response> samlSignatureSigner;
    protected final SamlResponseAssertionEncrypter samlResponseAssertionEncrypter;
    protected final ResponseAssertionSigner responseAssertionSigner;
    protected final ResponseSignatureCreator responseSignatureCreator;

    @Inject
    public ResponseToSignedStringTransformer(XmlObjectToBase64EncodedStringTransformer<?> xmlObjectToBase64EncodedStringTransformer, SamlSignatureSigner<Response> samlSignatureSigner, SamlResponseAssertionEncrypter samlResponseAssertionEncrypter, ResponseAssertionSigner responseAssertionSigner, ResponseSignatureCreator responseSignatureCreator) {
        this.xmlObjectToBase64EncodedStringTransformer = xmlObjectToBase64EncodedStringTransformer;
        this.samlSignatureSigner = samlSignatureSigner;
        this.samlResponseAssertionEncrypter = samlResponseAssertionEncrypter;
        this.responseAssertionSigner = responseAssertionSigner;
        this.responseSignatureCreator = responseSignatureCreator;
    }

    @Override
    public String apply(Response response) {
        Response responseWithSignature = this.responseSignatureCreator.addUnsignedSignatureTo(response);
        Response assertionSignedResponse = this.responseAssertionSigner.signAssertions(responseWithSignature);
        Response encryptedAssertionResponse = this.samlResponseAssertionEncrypter.encryptAssertions(assertionSignedResponse);
        Response signedResponse = this.samlSignatureSigner.sign(encryptedAssertionResponse);
        return this.xmlObjectToBase64EncodedStringTransformer.apply((XMLObject)signedResponse);
    }
}

