/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import uk.gov.ida.saml.core.domain.Gender;
import uk.gov.ida.saml.core.domain.NonMatchingAddress;
import uk.gov.ida.saml.core.domain.NonMatchingTransliterableAttribute;
import uk.gov.ida.saml.core.domain.NonMatchingVerifiableAttribute;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NonMatchingAttributes {
    protected final List<NonMatchingTransliterableAttribute> firstNames;
    protected final List<NonMatchingVerifiableAttribute<String>> middleNames;
    protected final List<NonMatchingTransliterableAttribute> surnames;
    protected final List<NonMatchingVerifiableAttribute<LocalDate>> datesOfBirth;
    protected final NonMatchingVerifiableAttribute<Gender> gender;
    protected final List<NonMatchingVerifiableAttribute<NonMatchingAddress>> addresses;

    @JsonCreator
    public NonMatchingAttributes(@JsonProperty(value="firstNames") List<NonMatchingTransliterableAttribute> firstNames, @JsonProperty(value="middleNames") List<NonMatchingVerifiableAttribute<String>> middleNames, @JsonProperty(value="surnames") List<NonMatchingTransliterableAttribute> surnames, @JsonProperty(value="datesOfBirth") List<NonMatchingVerifiableAttribute<LocalDate>> datesOfBirth, @JsonProperty(value="gender") NonMatchingVerifiableAttribute<Gender> gender, @JsonProperty(value="addresses") List<NonMatchingVerifiableAttribute<NonMatchingAddress>> addresses) {
        this.firstNames = firstNames;
        this.middleNames = middleNames;
        this.surnames = surnames;
        this.datesOfBirth = datesOfBirth;
        this.gender = gender;
        this.addresses = addresses;
    }

    public List<NonMatchingTransliterableAttribute> getFirstNames() {
        return this.firstNames;
    }

    public List<NonMatchingVerifiableAttribute<String>> getMiddleNames() {
        return this.middleNames;
    }

    public List<NonMatchingTransliterableAttribute> getSurnames() {
        return this.surnames;
    }

    public List<NonMatchingVerifiableAttribute<LocalDate>> getDatesOfBirth() {
        return this.datesOfBirth;
    }

    public NonMatchingVerifiableAttribute<Gender> getGender() {
        return this.gender;
    }

    public List<NonMatchingVerifiableAttribute<NonMatchingAddress>> getAddresses() {
        return this.addresses;
    }

    public static String combineAttributeValues(List<? extends NonMatchingVerifiableAttribute<String>> attributes) {
        return attributes.stream().filter(Objects::nonNull).map(NonMatchingVerifiableAttribute::getValue).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonMatchingAttributes that = (NonMatchingAttributes)o;
        if (!Objects.equals(this.firstNames, that.firstNames)) {
            return false;
        }
        if (this.middleNames != null ? that.middleNames == null || !CollectionUtils.isEqualCollection(this.middleNames, that.middleNames) : that.middleNames != null) {
            return false;
        }
        if (this.surnames != null ? that.surnames == null || !CollectionUtils.isEqualCollection(this.surnames, that.surnames) : that.surnames != null) {
            return false;
        }
        if (!Objects.equals(this.datesOfBirth, that.datesOfBirth)) {
            return false;
        }
        if (!Objects.equals(this.gender, that.gender)) {
            return false;
        }
        return this.addresses != null ? that.addresses == null || !CollectionUtils.isEqualCollection(this.addresses, that.addresses) : that.addresses != null;
    }

    public int hashCode() {
        int result = this.firstNames != null ? this.firstNames.hashCode() : 0;
        result = 31 * result + (this.middleNames != null ? this.middleNames.hashCode() : 0);
        result = 31 * result + (this.surnames != null ? this.surnames.hashCode() : 0);
        result = 31 * result + (this.datesOfBirth != null ? this.datesOfBirth.hashCode() : 0);
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("Attributes{ firstNames=%s, middleNames=%s, surnames=%s, datesOfBirth=%s, gender=%s, addresses=%s}", this.firstNames, this.middleNames, this.surnames, this.datesOfBirth, this.gender, this.addresses);
    }
}

