/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.criteria.impl.EvaluableCredentialCriterion;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.common.shared.security.verification.CertificateChainValidator;
import uk.gov.ida.common.shared.security.verification.CertificateValidity;
import uk.gov.ida.common.shared.security.verification.exceptions.CertificateChainValidationException;

public class CertificateChainEvaluableCriterion
implements EvaluableCredentialCriterion {
    private final CertificateChainValidator certificateChainValidator;
    private final KeyStore keyStore;
    private final Logger log = LoggerFactory.getLogger(CertificateChainEvaluableCriterion.class);

    public CertificateChainEvaluableCriterion(CertificateChainValidator certificateChainValidator, KeyStore keyStore) {
        this.certificateChainValidator = certificateChainValidator;
        this.keyStore = keyStore;
    }

    public boolean apply(Credential target) {
        if (target == null) {
            this.log.error("Credential target was null");
            return Boolean.FALSE;
        }
        if (!(target instanceof X509Credential)) {
            this.log.info("Credential is not an X509Credential, can not evaluate X509CertSelector criteria");
            return Boolean.FALSE;
        }
        X509Credential x509Cred = (X509Credential)target;
        X509Certificate entityCert = x509Cred.getEntityCertificate();
        if (entityCert == null) {
            this.log.info("X509Credential did not contain an entity certificate, can not evaluate X509CertSelector criteria");
            return Boolean.FALSE;
        }
        try {
            CertificateValidity result = this.certificateChainValidator.validate(entityCert, this.keyStore);
            if (result.isValid()) {
                return Boolean.TRUE;
            }
            result.getException().ifPresent(e -> this.log.info(e.getMessage()));
            return Boolean.FALSE;
        }
        catch (CertificateChainValidationException ex) {
            this.log.info(ex.getMessage());
            return Boolean.FALSE;
        }
    }
}

