/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata;

import com.google.common.base.Throwables;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.List;
import uk.gov.ida.saml.metadata.exception.TrustAnchorConfigException;

public class KeyStoreLoader {
    public KeyStore load(String uri, String password) {
        try {
            return this.load(new FileInputStream(uri), password);
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public KeyStore load(InputStream keystoreInputStream, String password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] charPassword = password.toCharArray();
            try (InputStream autoCloseableInputStream = keystoreInputStream;){
                keyStore.load(autoCloseableInputStream, charPassword);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public KeyStore load(List<Certificate> certificates) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            for (Certificate certificate : certificates) {
                keyStore.setCertificateEntry("certificate-" + certificates.indexOf(certificate), certificate);
            }
            return keyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new TrustAnchorConfigException("Unable to build key store", e);
        }
    }
}

