/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers.outbound.decorators;

import com.google.common.base.Throwables;
import java.util.List;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import uk.gov.ida.saml.security.EncrypterFactory;
import uk.gov.ida.saml.security.EncryptionCredentialResolver;
import uk.gov.ida.saml.security.EntityToEncryptForLocator;

public abstract class AbstractAssertionEncrypter<T> {
    protected final EncryptionCredentialResolver credentialResolver;
    protected final EncrypterFactory encrypterFactory;
    protected final EntityToEncryptForLocator entityToEncryptForLocator;

    public AbstractAssertionEncrypter(EncrypterFactory encrypterFactory, EntityToEncryptForLocator entityToEncryptForLocator, EncryptionCredentialResolver credentialResolver) {
        this.encrypterFactory = encrypterFactory;
        this.entityToEncryptForLocator = entityToEncryptForLocator;
        this.credentialResolver = credentialResolver;
    }

    public T encryptAssertions(T samlMessage) {
        if (this.getAssertions(samlMessage).size() > 0) {
            String entityToEncryptFor = this.entityToEncryptForLocator.fromRequestId(this.getRequestId(samlMessage));
            Credential credential = this.credentialResolver.getEncryptingCredential(entityToEncryptFor);
            Encrypter samlEncrypter = this.encrypterFactory.createEncrypter(credential);
            for (Assertion assertion : this.getAssertions(samlMessage)) {
                try {
                    EncryptedAssertion encryptedAssertion = samlEncrypter.encrypt(assertion);
                    this.getEncryptedAssertions(samlMessage).add(encryptedAssertion);
                }
                catch (EncryptionException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            this.getAssertions(samlMessage).removeAll(this.getAssertions(samlMessage));
        }
        return samlMessage;
    }

    protected abstract String getRequestId(T var1);

    protected abstract List<EncryptedAssertion> getEncryptedAssertions(T var1);

    protected abstract List<Assertion> getAssertions(T var1);
}

