/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security.signature;

import com.google.common.base.Strings;
import io.prometheus.client.Counter;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutgoingKeySignatureTrustEngine
extends ExplicitKeySignatureTrustEngine {
    private final Logger log = LoggerFactory.getLogger(OutgoingKeySignatureTrustEngine.class);
    private static final Counter outgoingSignatureVerifyingErrorCounter = (Counter)((Counter.Builder)Counter.build((String)"verify_saml_lib_signature_verifying_error_counter", (String)"Counter to detect errors on the outgoing signature, reports the number of errors").labelNames(new String[]{"error_type"})).register();

    public OutgoingKeySignatureTrustEngine(@Nonnull CredentialResolver resolver, @Nonnull KeyInfoCredentialResolver keyInfoResolver) {
        super(resolver, keyInfoResolver);
    }

    protected boolean doValidate(@Nonnull Signature signature, @Nullable CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable trustedCredentials;
        String jcaAlgorithm;
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.addAll((Collection)trustBasisCriteria);
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        if (!Strings.isNullOrEmpty((String)(jcaAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)signature.getSignatureAlgorithm())))) {
            criteriaSet.add((Object)new KeyAlgorithmCriterion(jcaAlgorithm), true);
        }
        try {
            trustedCredentials = this.getCredentialResolver().resolve((Object)criteriaSet);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted credentials", (Exception)((Object)e));
        }
        if (this.validate(signature, trustedCredentials)) {
            return true;
        }
        this.log.debug("Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            if (this.verifySignature(signature, trustedCredential)) {
                this.log.debug("Successfully verified signature using resolved trusted credential");
                return true;
            }
            ((Counter.Child)outgoingSignatureVerifyingErrorCounter.labels(new String[]{"verification_failed"})).inc();
            this.log.warn("Failed to verify signature using trusted credentials");
        }
        this.log.debug("Failed to verify signature using either KeyInfo-derived or directly trusted credentials");
        return false;
    }
}

