/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.transformers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.saml.core.domain.Address;
import uk.gov.ida.saml.core.domain.AddressFactory;
import uk.gov.ida.saml.core.domain.Gender;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.domain.TransliterableMdsValue;
import uk.gov.ida.saml.core.extensions.PersonName;
import uk.gov.ida.saml.core.transformers.MatchingDatasetBuilder;
import uk.gov.ida.saml.core.transformers.MatchingDatasetUnmarshaller;

public class VerifyMatchingDatasetUnmarshaller
extends MatchingDatasetUnmarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyMatchingDatasetUnmarshaller.class);
    private final AddressFactory addressFactory;

    public VerifyMatchingDatasetUnmarshaller(AddressFactory addressFactory) {
        this.addressFactory = addressFactory;
    }

    @Override
    protected void transformAttribute(Attribute attribute, MatchingDatasetBuilder datasetBuilder) {
        switch (attribute.getName()) {
            case "MDS_firstname": {
                datasetBuilder.addFirstNames(this.transformPersonNameAttribute(attribute).stream().map(TransliterableMdsValue::new).collect(Collectors.toList()));
                break;
            }
            case "MDS_middlename": {
                datasetBuilder.middlenames(this.transformPersonNameAttribute(attribute));
                break;
            }
            case "MDS_surname": {
                datasetBuilder.addSurnames(this.transformPersonNameAttribute(attribute).stream().map(TransliterableMdsValue::new).collect(Collectors.toList()));
                break;
            }
            case "MDS_gender": {
                uk.gov.ida.saml.core.extensions.Gender gender = (uk.gov.ida.saml.core.extensions.Gender)attribute.getAttributeValues().get(0);
                datasetBuilder.gender(new SimpleMdsValue<Gender>(Gender.fromString(gender.getValue()), gender.getFrom(), gender.getTo(), gender.getVerified()));
                break;
            }
            case "MDS_dateofbirth": {
                datasetBuilder.dateOfBirth(this.getBirthDates(attribute));
                break;
            }
            case "MDS_currentaddress": {
                List<Address> transformedCurrentAddresses = this.addressFactory.create(attribute);
                datasetBuilder.addCurrentAddresses(transformedCurrentAddresses);
                break;
            }
            case "MDS_previousaddress": {
                List<Address> transformedPreviousAddresses = this.addressFactory.create(attribute);
                datasetBuilder.addPreviousAddresses(transformedPreviousAddresses);
                break;
            }
            default: {
                String errorMessage = MessageFormat.format("Attribute {0} is not a supported Matching Dataset attribute.", attribute.getName());
                LOG.warn(errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
        }
    }

    @Override
    protected String getPersonalIdentifier(Assertion assertion) {
        return assertion.getSubject().getNameID().getValue();
    }

    private List<SimpleMdsValue<String>> transformPersonNameAttribute(Attribute attribute) {
        ArrayList<SimpleMdsValue<String>> personNames = new ArrayList<SimpleMdsValue<String>>();
        for (XMLObject xmlObject : attribute.getAttributeValues()) {
            PersonName personName = (PersonName)xmlObject;
            personNames.add(new SimpleMdsValue<String>(personName.getValue(), personName.getFrom(), personName.getTo(), personName.getVerified()));
        }
        return personNames;
    }
}

