/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security.validators.issuer;

import com.google.common.base.Strings;
import org.opensaml.saml.saml2.core.Issuer;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.security.errors.SamlTransformationErrorFactory;

public class IssuerValidator {
    public void validate(Issuer assertionIssuer) {
        if (assertionIssuer == null) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.missingIssuer();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (Strings.isNullOrEmpty((String)assertionIssuer.getValue())) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.emptyIssuer();
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        if (assertionIssuer.getFormat() != null && !"urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(assertionIssuer.getFormat())) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.illegalIssuerFormat(assertionIssuer.getFormat(), "urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
    }
}

