/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.hub.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.joda.time.LocalDate;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeValue;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;
import uk.gov.ida.saml.core.domain.Address;
import uk.gov.ida.saml.core.domain.Gender;
import uk.gov.ida.saml.core.domain.SimpleMdsValue;
import uk.gov.ida.saml.core.extensions.Date;
import uk.gov.ida.saml.core.extensions.Gpg45Status;
import uk.gov.ida.saml.core.extensions.IPAddress;
import uk.gov.ida.saml.core.extensions.IdpFraudEventId;
import uk.gov.ida.saml.core.extensions.Line;
import uk.gov.ida.saml.core.extensions.PersonName;
import uk.gov.ida.saml.core.extensions.StringBasedMdsAttributeValue;
import uk.gov.ida.saml.hub.factories.AttributeFactory;

public class AttributeFactory_1_1
implements AttributeFactory {
    private final OpenSamlXmlObjectFactory openSamlXmlObjectFactory;

    @Inject
    public AttributeFactory_1_1(OpenSamlXmlObjectFactory openSamlXmlObjectFactory) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
    }

    @Override
    public Attribute createFirstnameAttribute(List<SimpleMdsValue<String>> firstnames) {
        return this.createPersonNameAttribute(firstnames, "MDS_firstname", "Firstname");
    }

    @Override
    public Attribute createMiddlenamesAttribute(List<SimpleMdsValue<String>> middlenames) {
        return this.createPersonNameAttribute(middlenames, "MDS_middlename", "Middlename(s)");
    }

    @Override
    public Attribute createSurnameAttribute(List<SimpleMdsValue<String>> surnames) {
        return this.createPersonNameAttribute(surnames, "MDS_surname", "Surname");
    }

    @Override
    public Attribute createGenderAttribute(SimpleMdsValue<Gender> gender) {
        uk.gov.ida.saml.core.extensions.Gender genderValue = this.openSamlXmlObjectFactory.createGenderAttributeValue(gender.getValue().getValue());
        genderValue.setFrom(gender.getFrom());
        genderValue.setTo(gender.getTo());
        genderValue.setVerified(gender.isVerified());
        return this.createAttribute("MDS_gender", "Gender", Arrays.asList(genderValue));
    }

    @Override
    public Attribute createDateOfBirthAttribute(List<SimpleMdsValue<LocalDate>> dateOfBirths) {
        return this.createAttribute("MDS_dateofbirth", "Date of Birth", this.createAttributeValuesForDate(dateOfBirths));
    }

    @Override
    public Attribute createCurrentAddressesAttribute(List<Address> currentAddresses) {
        Attribute currentAddressesAttribute = this.openSamlXmlObjectFactory.createAttribute();
        currentAddressesAttribute.setName("MDS_currentaddress");
        currentAddressesAttribute.setFriendlyName("Current Address");
        currentAddressesAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        for (Address address : currentAddresses) {
            AttributeValue addressAttributeValue = this.createAddressAttributeValue(address);
            currentAddressesAttribute.getAttributeValues().add(addressAttributeValue);
        }
        return currentAddressesAttribute;
    }

    @Override
    public Attribute createPreviousAddressesAttribute(List<Address> addresses) {
        Attribute addressAttribute = this.openSamlXmlObjectFactory.createAttribute();
        addressAttribute.setName("MDS_previousaddress");
        addressAttribute.setFriendlyName("Previous Address");
        addressAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        for (Address address : addresses) {
            AttributeValue addressAttributeValue = this.createAddressAttributeValue(address);
            addressAttribute.getAttributeValues().add(addressAttributeValue);
        }
        return addressAttribute;
    }

    @Override
    public Attribute createCycle3DataAttribute(String attributeName, String cycle3Data) {
        StringBasedMdsAttributeValue stringBasedMdsAttributeValue = this.openSamlXmlObjectFactory.createSimpleMdsAttributeValue(cycle3Data);
        return this.createAttribute(attributeName, null, Arrays.asList(stringBasedMdsAttributeValue));
    }

    @Override
    public Attribute createIdpFraudEventIdAttribute(String fraudEventId) {
        IdpFraudEventId idpFraudEventId = this.openSamlXmlObjectFactory.createIdpFraudEventAttributeValue(fraudEventId);
        return this.createAttribute("FECI_IDPFraudEventID", "IDPFraudEventID", Arrays.asList(idpFraudEventId));
    }

    @Override
    public Attribute createGpg45StatusAttribute(String indicator) {
        Gpg45Status gpg45StatusAttributeValue = this.openSamlXmlObjectFactory.createGpg45StatusAttributeValue(indicator);
        return this.createAttribute("FECI_GPG45Status", "GPG45Status", Arrays.asList(gpg45StatusAttributeValue));
    }

    @Override
    public Attribute createUserIpAddressAttribute(String userIpAddressString) {
        IPAddress ipAddress = this.openSamlXmlObjectFactory.createIPAddressAttributeValue(userIpAddressString);
        return this.createAttribute("TXN_IPaddress", "IPAddress", Arrays.asList(ipAddress));
    }

    private Attribute createPersonNameAttribute(List<SimpleMdsValue<String>> names, String attributeName, String attributeFriendlyName) {
        List<AttributeValue> personNameAttributeValues = this.createAttributeValuesForPersonName(names);
        return this.createAttribute(attributeName, attributeFriendlyName, personNameAttributeValues);
    }

    private AttributeValue createAddressAttributeValue(Address address) {
        uk.gov.ida.saml.core.extensions.Address addressAttributeValue = this.openSamlXmlObjectFactory.createAddressAttributeValue();
        addressAttributeValue.setFrom(address.getFrom());
        if (address.getTo().isPresent()) {
            addressAttributeValue.setTo(address.getTo().get());
        }
        for (String lineValue : address.getLines()) {
            Line line = this.openSamlXmlObjectFactory.createLine(lineValue);
            addressAttributeValue.getLines().add(line);
        }
        if (address.getPostCode().isPresent()) {
            addressAttributeValue.setPostCode(this.openSamlXmlObjectFactory.createPostCode(address.getPostCode().get()));
        }
        if (address.getInternationalPostCode().isPresent()) {
            addressAttributeValue.setInternationalPostCode(this.openSamlXmlObjectFactory.createInternationalPostCode(address.getInternationalPostCode().get()));
        }
        if (address.getUPRN().isPresent()) {
            addressAttributeValue.setUPRN(this.openSamlXmlObjectFactory.createUPRN(address.getUPRN().get()));
        }
        addressAttributeValue.setVerified(address.isVerified());
        return addressAttributeValue;
    }

    private Attribute createAttribute(String attributeName, String attributeFriendlyName, List<? extends XMLObject> attributeValues) {
        Attribute nameAttribute = this.openSamlXmlObjectFactory.createAttribute();
        nameAttribute.setName(attributeName);
        nameAttribute.setFriendlyName(attributeFriendlyName);
        nameAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
        nameAttribute.getAttributeValues().addAll(attributeValues);
        return nameAttribute;
    }

    private List<AttributeValue> createAttributeValuesForPersonName(List<SimpleMdsValue<String>> nameValues) {
        ArrayList<AttributeValue> personNameAttributeValues = new ArrayList<AttributeValue>();
        for (SimpleMdsValue<String> value : nameValues) {
            PersonName personNameAttributeValue = this.openSamlXmlObjectFactory.createPersonNameAttributeValue(value.getValue());
            personNameAttributeValue.setFrom(value.getFrom());
            personNameAttributeValue.setTo(value.getTo());
            personNameAttributeValue.setVerified(value.isVerified());
            personNameAttributeValues.add(personNameAttributeValue);
        }
        return personNameAttributeValues;
    }

    private List<AttributeValue> createAttributeValuesForDate(List<SimpleMdsValue<LocalDate>> dateValues) {
        ArrayList<AttributeValue> personNameAttributeValues = new ArrayList<AttributeValue>();
        for (SimpleMdsValue<LocalDate> value : dateValues) {
            Date personNameAttributeValue = this.openSamlXmlObjectFactory.createDateAttributeValue(value.getValue().toString("yyyy-MM-dd"));
            personNameAttributeValue.setFrom(value.getFrom());
            personNameAttributeValue.setTo(value.getTo());
            personNameAttributeValue.setVerified(value.isVerified());
            personNameAttributeValues.add(personNameAttributeValue);
        }
        return personNameAttributeValues;
    }
}

