/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import uk.gov.ida.saml.security.SigningKeyStore;

public class SigningCredentialFactory {
    private final SigningKeyStore signingKeyStore;

    public SigningCredentialFactory(SigningKeyStore signingKeyStore) {
        this.signingKeyStore = signingKeyStore;
    }

    public List<Credential> getVerifyingCredentials(String entityId) {
        ArrayList<Credential> verifyingCredentials = new ArrayList<Credential>();
        List<PublicKey> verifyingKeysForEntity = this.signingKeyStore.getVerifyingKeysForEntity(entityId);
        for (PublicKey verifyingKeyForEntity : verifyingKeysForEntity) {
            BasicCredential credential = new BasicCredential(verifyingKeyForEntity);
            credential.setUsageType(UsageType.SIGNING);
            verifyingCredentials.add((Credential)credential);
        }
        return verifyingCredentials;
    }
}

