/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.factories;

import io.dropwizard.setup.Environment;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.client.Client;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import uk.gov.ida.common.shared.security.X509CertificateFactory;
import uk.gov.ida.common.shared.security.verification.CertificateChainValidator;
import uk.gov.ida.common.shared.security.verification.PKIXParametersProvider;
import uk.gov.ida.saml.metadata.CertificateChainValidationFilter;
import uk.gov.ida.saml.metadata.ExpiredCertificateMetadataFilter;
import uk.gov.ida.saml.metadata.MetadataResolverConfiguration;
import uk.gov.ida.saml.metadata.PKIXSignatureValidationFilterProvider;
import uk.gov.ida.saml.metadata.factories.MetadataClientFactory;
import uk.gov.ida.saml.metadata.factories.MetadataResolverFactory;

public class DropwizardMetadataResolverFactory {
    private final MetadataResolverFactory metadataResolverFactory = new MetadataResolverFactory();
    private final ExpiredCertificateMetadataFilter expiredCertificateMetadataFilter = new ExpiredCertificateMetadataFilter();
    private final MetadataClientFactory metadataClientFactory = new MetadataClientFactory();
    private final CertificateChainValidator certificateChainValidator = new CertificateChainValidator(new PKIXParametersProvider(), new X509CertificateFactory());

    public MetadataResolver createMetadataResolver(Environment environment, MetadataResolverConfiguration metadataConfiguration) {
        return this.createMetadataResolver(environment, metadataConfiguration, true);
    }

    public MetadataResolver createMetadataResolverWithoutSignatureValidation(Environment environment, MetadataResolverConfiguration metadataConfiguration) {
        return this.createMetadataResolver(environment, metadataConfiguration, false);
    }

    public MetadataResolver createMetadataResolver(Environment environment, MetadataResolverConfiguration metadataConfiguration, boolean validateSignatures) {
        return this.createMetadataResolverWithClient(metadataConfiguration, validateSignatures, this.metadataClientFactory.getClient(environment, metadataConfiguration));
    }

    public MetadataResolver createMetadataResolverWithClient(MetadataResolverConfiguration metadataConfiguration, boolean validateSignatures, Client client) {
        URI uri = metadataConfiguration.getUri();
        Long minRefreshDelay = metadataConfiguration.getMinRefreshDelay();
        Long maxRefreshDelay = metadataConfiguration.getMaxRefreshDelay();
        return this.metadataResolverFactory.create(client, uri, this.getMetadataFilters(metadataConfiguration, validateSignatures, metadataConfiguration.getHubTrustStore(), metadataConfiguration.getIdpTrustStore()), minRefreshDelay, maxRefreshDelay);
    }

    private List<MetadataFilter> getMetadataFilters(MetadataResolverConfiguration metadataConfiguration, boolean validateSignatures, Optional<KeyStore> hubTrustStore, Optional<KeyStore> idpTrustStore) {
        if (!validateSignatures) {
            return Collections.emptyList();
        }
        KeyStore metadataTrustStore = metadataConfiguration.getTrustStore();
        PKIXSignatureValidationFilterProvider pkixSignatureValidationFilterProvider = new PKIXSignatureValidationFilterProvider(metadataTrustStore);
        ArrayList<Object> metadataFilters = new ArrayList<Object>();
        metadataFilters.add(pkixSignatureValidationFilterProvider.get());
        metadataFilters.add(this.expiredCertificateMetadataFilter);
        hubTrustStore.ifPresent(hubKeyStore -> metadataFilters.add(new CertificateChainValidationFilter(SPSSODescriptor.DEFAULT_ELEMENT_NAME, this.certificateChainValidator, (KeyStore)hubKeyStore)));
        idpTrustStore.ifPresent(idpKeyStore -> metadataFilters.add(new CertificateChainValidationFilter(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, this.certificateChainValidator, (KeyStore)idpKeyStore)));
        return Collections.unmodifiableList(new ArrayList(metadataFilters));
    }
}

