/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.deserializers.validators;

import java.util.regex.Pattern;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.commons.codec.binary.StringUtils;
import uk.gov.ida.saml.core.validation.SamlTransformationErrorException;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.errors.SamlTransformationErrorFactory;

public class Base64StringDecoder {
    public String decode(String input) {
        String withoutWhitespace = input.replaceAll("\\s", "");
        if (!Pattern.matches("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$", withoutWhitespace)) {
            SamlValidationSpecificationFailure failure = SamlTransformationErrorFactory.invalidBase64Encoding(input);
            throw new SamlTransformationErrorException(failure.getErrorMessage(), failure.getLogLevel());
        }
        return StringUtils.newStringUtf8((byte[])Base64Support.decode((String)input));
    }
}

