/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import java.io.Serializable;
import java.util.Optional;
import uk.gov.ida.saml.core.domain.AuthnContext;
import uk.gov.ida.saml.core.domain.FraudDetectedDetails;
import uk.gov.ida.saml.core.domain.PersistentId;

public class PassthroughAssertion
implements Serializable {
    private PersistentId persistentId;
    private Optional<AuthnContext> authnContext;
    private String underlyingAssertionBlob;
    private Optional<FraudDetectedDetails> fraudDetectedDetails;
    private Optional<String> principalIpAddressAsSeenByIdp;

    public PassthroughAssertion(PersistentId persistentId, Optional<AuthnContext> levelOfAssurance, String underlyingAssertionBlob, Optional<FraudDetectedDetails> fraudDetectedDetails, Optional<String> principalIpAddressAsSeenByIdp) {
        this.persistentId = persistentId;
        this.authnContext = levelOfAssurance;
        this.underlyingAssertionBlob = underlyingAssertionBlob;
        this.fraudDetectedDetails = fraudDetectedDetails;
        this.principalIpAddressAsSeenByIdp = principalIpAddressAsSeenByIdp;
    }

    public String getUnderlyingAssertionBlob() {
        return this.underlyingAssertionBlob;
    }

    public Optional<AuthnContext> getAuthnContext() {
        return this.authnContext;
    }

    public PersistentId getPersistentId() {
        return this.persistentId;
    }

    public boolean isFraudulent() {
        return this.authnContext.isPresent() && this.authnContext.get().equals((Object)AuthnContext.LEVEL_X);
    }

    public Optional<FraudDetectedDetails> getFraudDetectedDetails() {
        return this.fraudDetectedDetails;
    }

    public Optional<String> getPrincipalIpAddressAsSeenByIdp() {
        return this.principalIpAddressAsSeenByIdp;
    }
}

