/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.joda.time.DateTime;
import uk.gov.ida.saml.core.domain.MdsAttributeValue;

public class Address
implements MdsAttributeValue,
Serializable {
    private boolean verified;
    private DateTime from;
    private Optional<DateTime> to = Optional.empty();
    private Optional<String> postCode = Optional.empty();
    private List<String> lines;
    private Optional<String> internationalPostCode = Optional.empty();
    private Optional<String> uprn = Optional.empty();

    public Address(List<String> lines, String postCode, String internationalPostCode, String uprn, DateTime from, DateTime to, boolean verified) {
        this.internationalPostCode = Optional.ofNullable(internationalPostCode);
        this.uprn = Optional.ofNullable(uprn);
        this.from = from;
        this.postCode = Optional.ofNullable(postCode);
        this.lines = lines;
        this.to = Optional.ofNullable(to);
        this.verified = verified;
    }

    @JsonCreator
    public Address(@JsonProperty(value="lines") List<String> lines, @JsonProperty(value="postCode") Optional<String> postCode, @JsonProperty(value="internationalPostCode") Optional<String> internationalPostCode, @JsonProperty(value="uprn") Optional<String> uprn, @JsonProperty(value="from") DateTime from, @JsonProperty(value="to") Optional<DateTime> to, @JsonProperty(value="verified") boolean verified) {
        this.lines = lines;
        this.postCode = postCode;
        this.internationalPostCode = internationalPostCode;
        this.uprn = uprn;
        this.from = from;
        this.to = to;
        this.verified = verified;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public Optional<String> getPostCode() {
        return this.postCode;
    }

    public Optional<String> getInternationalPostCode() {
        return this.internationalPostCode;
    }

    public Optional<String> getUPRN() {
        return this.uprn;
    }

    @Override
    public DateTime getFrom() {
        return this.from;
    }

    @Override
    public Optional<DateTime> getTo() {
        return this.to;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }
}

