/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.security;

import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;

public class EncrypterFactory {
    private String keyEncryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    private String dataEncryptionAlgorithm = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private Encrypter.KeyPlacement keyPlacement = Encrypter.KeyPlacement.PEER;

    public EncrypterFactory withKeyEncryptionAlgorithm(String algorithm) {
        this.keyEncryptionAlgorithm = algorithm;
        return this;
    }

    public EncrypterFactory withDataEncryptionAlgorithm(String algorithm) {
        this.dataEncryptionAlgorithm = algorithm;
        return this;
    }

    public EncrypterFactory withKeyPlacement(Encrypter.KeyPlacement keyPlacement) {
        this.keyPlacement = keyPlacement;
        return this;
    }

    public Encrypter createEncrypter(Credential credential) {
        DataEncryptionParameters encParams = new DataEncryptionParameters();
        encParams.setAlgorithm(this.dataEncryptionAlgorithm);
        KeyEncryptionParameters kekParams = new KeyEncryptionParameters();
        kekParams.setEncryptionCredential(credential);
        kekParams.setAlgorithm(this.keyEncryptionAlgorithm);
        Encrypter encrypter = new Encrypter(encParams, kekParams);
        encrypter.setKeyPlacement(this.keyPlacement);
        return encrypter;
    }
}

