/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.core.errors;

import java.net.URI;
import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.slf4j.event.Level;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.SamlValidationSpecificationWarning;
import uk.gov.ida.saml.core.validation.errors.AuthnContextMissingError;
import uk.gov.ida.saml.core.validation.errors.AuthnRequestFromTransactionValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.BearerSubjectConfirmationValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.DuplicateRequestIdValidationSpecificationFailure;
import uk.gov.ida.saml.core.validation.errors.GenericHubProfileValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.InvalidAttributeLanguageInAssertion;
import uk.gov.ida.saml.core.validation.errors.InvalidAttributeNameFormat;
import uk.gov.ida.saml.core.validation.errors.RelayStateValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.RequestFreshnessValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.ResponseProcessingValidationSpecification;
import uk.gov.ida.saml.core.validation.errors.SamlValidationSpecification;

public final class SamlTransformationErrorFactory {
    private SamlTransformationErrorFactory() {
    }

    public static SamlValidationSpecificationFailure duplicateRequestId(String requestId, String issuerId) {
        return new DuplicateRequestIdValidationSpecificationFailure("Duplicate request ID {0} from issuer {1}.", requestId, issuerId);
    }

    public static SamlValidationSpecificationFailure authnContextMissingError() {
        return new AuthnContextMissingError("Assertion is missing 'AuthnContext' element.", false, new Object[0]);
    }

    public static SamlValidationSpecificationFailure scopingNotAllowed() {
        return new AuthnRequestFromTransactionValidationSpecification("''Scoping'' element is not allowed.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure illegalProtocolBindingError(String protocolBinding, String expectedProtocolBinding) {
        return new AuthnRequestFromTransactionValidationSpecification("''ProtocolBinding'' has illegal value: {0}. Value must be set to {1}.", protocolBinding, expectedProtocolBinding);
    }

    public static SamlValidationSpecificationFailure unrecognisedBinding(String binding) {
        return new AuthnRequestFromTransactionValidationSpecification("{0} is not a recognised binding.", binding);
    }

    public static SamlValidationSpecificationFailure isPassiveNotAllowed() {
        return new AuthnRequestFromTransactionValidationSpecification("''IsPassive'' attribute is not allowed.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingNameIDPolicy() {
        return new AuthnRequestFromTransactionValidationSpecification("Name ID policy format is missing.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure illegalNameIDPolicy(String policy) {
        return new AuthnRequestFromTransactionValidationSpecification("Name ID policy format has illegal value: {0}.", policy);
    }

    public static SamlValidationSpecificationFailure attributeStatementEmpty(String assertionId) {
        return new ResponseProcessingValidationSpecification("The assertion MUST contain an <AttributeStatement> with at least one <Attribute> element. Assertion Id: {0} doesn''t.", assertionId);
    }

    public static SamlValidationSpecificationFailure missingInResponseTo() {
        return new ResponseProcessingValidationSpecification("Response has no 'InResponseTo' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure emptyInResponseTo() {
        return new ResponseProcessingValidationSpecification("Response 'InResponseTo' attribute is empty.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure authnContextClassRefMissing() {
        return new ResponseProcessingValidationSpecification("Assertion is missing 'AuthnContextClassRef' element.", new Object[]{false});
    }

    public static SamlValidationSpecificationFailure authnContextClassRefValueMissing() {
        return new ResponseProcessingValidationSpecification("Assertion is missing 'AuthnContextClassRef' value.", new Object[]{false});
    }

    public static SamlValidationSpecificationFailure authnInstantMissing() {
        return new ResponseProcessingValidationSpecification("AuthnStatement is missing 'AuthnInstant'", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingAuthnStatement() {
        return new ResponseProcessingValidationSpecification("Assertion is missing 'AuthnStatement' element.", new Object[]{false});
    }

    public static SamlValidationSpecificationFailure multipleAuthnStatements() {
        return new ResponseProcessingValidationSpecification("Response contains multiple authn statements.", new Object[]{false});
    }

    public static SamlValidationSpecificationFailure authnStatementAlreadyReceived(String id) {
        return new ResponseProcessingValidationSpecification("An authn statement assertion with id {0} has already been received.", id);
    }

    public static SamlValidationSpecificationFailure missingAssertionSubject(String id) {
        return new ResponseProcessingValidationSpecification("Assertion with id {0} has no subject.", id);
    }

    public static SamlValidationSpecificationFailure assertionSubjectHasNoNameID(String id) {
        return new ResponseProcessingValidationSpecification("Subject for assertion with id {0} has no name id.", id);
    }

    public static SamlValidationSpecificationFailure missingAssertionSubjectNameIDFormat(String id) {
        return new ResponseProcessingValidationSpecification("Subject''s name id format for assertion with id {0} is missing.", id);
    }

    public static SamlValidationSpecificationFailure illegalAssertionSubjectNameIDFormat(String id, String format) {
        return new ResponseProcessingValidationSpecification("Subject''s name id format for assertion with id {0} has illegal value {1}.", id, format);
    }

    public static SamlValidationSpecificationFailure unencryptedAssertion() {
        return new ResponseProcessingValidationSpecification("Response has unencrypted assertion.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingSuccessUnEncryptedAssertions() {
        return new ResponseProcessingValidationSpecification("Success response has no unencrypted assertions.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure nonSuccessHasUnEncryptedAssertions() {
        return new ResponseProcessingValidationSpecification("Non-success response has unencrypted assertions. Should contain no assertions.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingMatchingMds() {
        return new GenericHubProfileValidationSpecification("Missing a matching dataset assertion.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure emptyIssuer() {
        return new GenericHubProfileValidationSpecification("SAML ''Issuer'' element has no value.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure illegalIssuerFormat(String providedFormat, String expectedFormat) {
        return new GenericHubProfileValidationSpecification("SAML ''Issuer'' has wrong format: {0}, expected {1}.", providedFormat, expectedFormat);
    }

    public static SamlValidationSpecificationFailure destinationMissing(URI expectedUri) {
        return new GenericHubProfileValidationSpecification("Destination should not be absent. Expected: {0}.", expectedUri);
    }

    public static SamlValidationSpecificationFailure destinationEmpty(URI expectedUri, String destination) {
        return new GenericHubProfileValidationSpecification("Destination is incorrect. Expected: {0} Received: {1}.", expectedUri, destination);
    }

    public static SamlValidationSpecificationFailure destinationInvalid(URI uri, String endpoint) {
        return new GenericHubProfileValidationSpecification("Destination is incorrect. Received: {0}{1}{2}", uri.getScheme(), uri.getPath(), endpoint);
    }

    public static SamlValidationSpecificationFailure assertionNotSigned(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} is not signed", id);
    }

    public static SamlValidationSpecificationFailure assertionSignatureMissing(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} has no signature.", id);
    }

    public static SamlValidationSpecificationFailure missingIssueInstant(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} has no ''IssueInstant'' attribute", id);
    }

    public static SamlValidationSpecificationFailure missingVersion(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} has no ''Version'' attribute", id);
    }

    public static SamlValidationSpecificationFailure illegalVersion(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} declared an illegal ''Version'' attribute value", id);
    }

    public static SamlValidationSpecificationFailure noSubjectConfirmationWithBearerMethod(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} has no subject confirmation with method set to bearer.", id);
    }

    public static SamlValidationSpecificationFailure emptyIPAddress(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} IP address attribute contains no value.", id);
    }

    public static SamlValidationSpecificationFailure missingIPAddress(String id) {
        return new GenericHubProfileValidationSpecification("Assertion with id {0} is missing an IP address attribute.", id);
    }

    public static SamlValidationSpecificationFailure duplicateMatchingDataset(String id, String responseIssuerId) {
        return new GenericHubProfileValidationSpecification(Level.WARN, "A matching dataset assertion with id {0} has already been received for idp {1}", id, responseIssuerId);
    }

    public static SamlValidationSpecificationFailure mdsStatementMissing() {
        return new GenericHubProfileValidationSpecification("Matching dataset contains no attribute statements.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure mdsMultipleStatements() {
        return new GenericHubProfileValidationSpecification("Matching dataset contains multiple attribute statements.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure mdsAttributeNotRecognised(String attributeName) {
        return new GenericHubProfileValidationSpecification("''{0}'' is not a recognised matching dataset attribute.", attributeName);
    }

    public static SamlValidationSpecificationFailure emptyAttribute(String attributeName) {
        return new GenericHubProfileValidationSpecification("Attribute ''{0}'' does not have a value.", attributeName);
    }

    public static SamlValidationSpecificationFailure attributeWithIncorrectType(String attributeName, QName expected, QName received) {
        return new GenericHubProfileValidationSpecification("Attribute ''{0}'' has incorrect type. Should be ''{1}'' but got ''{2}''.", attributeName, expected, received);
    }

    public static SamlValidationSpecificationFailure illegalRequestVersionNumber() {
        return new AuthnRequestFromTransactionValidationSpecification("SAML 'Version Number' has incorrect value. Should be 2.0.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure requestTooOld(String requestId, DateTime issueInstant, DateTime currentTime) {
        return new RequestFreshnessValidationSpecification("Request ID {0} too old (request issueInstant {1}, current time {2}).", requestId, issueInstant, currentTime);
    }

    public static SamlValidationSpecificationFailure missingRequestId() {
        return new AuthnRequestFromTransactionValidationSpecification("SAML is missing ''ID'' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingRequestIssueInstant(String requestId) {
        return new AuthnRequestFromTransactionValidationSpecification("Assertion with id {0} has no ''IssueInstant'' attribute", requestId);
    }

    public static SamlValidationSpecificationFailure missingRequestVersion(String requestId) {
        return new AuthnRequestFromTransactionValidationSpecification("Assertion with id {0} has no ''Version'' attribute", requestId);
    }

    public static SamlValidationSpecificationFailure nestedSubStatusCodesBreached(int subStatusCodeLimit) {
        return new GenericHubProfileValidationSpecification("More than {0} nested sub-status codes are not permitted.", subStatusCodeLimit);
    }

    public static SamlValidationSpecificationFailure invalidStatusCode(String statusCode) {
        return new GenericHubProfileValidationSpecification("Status code ''{0}'' is not a valid status code.", statusCode);
    }

    public static SamlValidationSpecificationFailure invalidSubStatusCode(String subStatusCode, String statusCode) {
        return new GenericHubProfileValidationSpecification("Sub-status ''{0}'' is not a valid sub-status when top-level status is ''{1}''.", subStatusCode, statusCode);
    }

    public static SamlValidationSpecificationFailure subStatusMustBeOneOf(String subStatus, String code1, String code2, String code3) {
        return new ResponseProcessingValidationSpecification("''{0}'' response sub status must be ''{1}'', ''{2}'', or ''{3}''.", subStatus, code1, code2, code3);
    }

    public static SamlValidationSpecificationFailure missingSubStatus() {
        return new ResponseProcessingValidationSpecification("Response requires a sub status.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure unexpectedNumberOfAssertions(int expected, int actual) {
        return new ResponseProcessingValidationSpecification("Response expected to contain {0} assertions. {1} assertion(s) found.", expected, actual);
    }

    public static SamlValidationSpecificationFailure notMatchInResponseTo(String inResponseTo, String requestId) {
        return new BearerSubjectConfirmationValidationSpecification("Bearer subject confirmation data''s ''InResponseTo'' attribute ({0}) was not the same as the Response''s ''InResponseTo'' ({1}).", inResponseTo, requestId);
    }

    public static SamlValidationSpecificationFailure incorrectRecipientFormat(String recipient, String expectedRecipient) {
        return new BearerSubjectConfirmationValidationSpecification("''{0}'' - Bearer subject confirmation data ''Recipient'' attribute is not set to the expected value. Expected value was {1}", recipient, expectedRecipient);
    }

    public static SamlValidationSpecificationFailure missingSubjectConfirmationData() {
        return new BearerSubjectConfirmationValidationSpecification("Bearer subject confirmation has no ''SubjectConfirmationData'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingBearerInResponseTo() {
        return new BearerSubjectConfirmationValidationSpecification("Bearer subject confirmation data has no ''InResponseTo'' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingBearerRecipient() {
        return new BearerSubjectConfirmationValidationSpecification("Bearer subject confirmation data has no ''Recipient'' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingNotOnOrAfter() {
        return new BearerSubjectConfirmationValidationSpecification("Bearer subject confirmation data has no ''NotOnOrAfter'' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure exceededNotOnOrAfter(DateTime expiredTime) {
        return new BearerSubjectConfirmationValidationSpecification(Level.WARN, "Bearer subject confirmation data''s ''NotOnOrAfter'' timestamp of {0} has been exceeded.", expiredTime);
    }

    public static SamlValidationSpecificationFailure notBeforeExists() {
        return new BearerSubjectConfirmationValidationSpecification("Bearer subject confirmation data contains a ''NotBefore'' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingOrEmptyEntityID() {
        return new GenericHubProfileValidationSpecification("SAML ''EntityID'' attribute is missing or has no value.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingCacheDurationAndValidUntil() {
        return new GenericHubProfileValidationSpecification("Neither of Entity Descriptor's 'CacheDuration' & 'ValidUntil' attributes were provided. At least one must be provided.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingRoleDescriptor() {
        return new GenericHubProfileValidationSpecification("EntityDescriptor is missing a 'RoleDescriptor' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingKeyDescriptor() {
        return new GenericHubProfileValidationSpecification("RoleDescriptor is missing a ''KeyDescriptor'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingKeyInfo() {
        return new GenericHubProfileValidationSpecification("KeyDescriptor is missing a ''KeyInfo'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingX509Data() {
        return new GenericHubProfileValidationSpecification("KeyInfo is missing a ''X509Data'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingX509Certificate() {
        return new GenericHubProfileValidationSpecification("X509Data is missing a ''X509Certificate'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure emptyX509Certificiate() {
        return new GenericHubProfileValidationSpecification("X509Certificate element is empty.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingOrganization() {
        return new GenericHubProfileValidationSpecification("EntityDescriptor is missing 'Organization' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingDisplayName() {
        return new GenericHubProfileValidationSpecification("EntityDescriptor is missing an organization 'DisplayName' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingSignature() {
        return new GenericHubProfileValidationSpecification("Message has no signature.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure signatureNotSigned() {
        return new GenericHubProfileValidationSpecification("Message signature is not signed", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingIssuer() {
        return new GenericHubProfileValidationSpecification("SAML is missing ''Issuer'' element.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingId() {
        return new GenericHubProfileValidationSpecification("SAML is missing ''ID'' attribute.", new Object[0]);
    }

    public static SamlValidationSpecificationFailure missingKey(String key, String entity) {
        return new GenericHubProfileValidationSpecification("Could not find expected key for {0} for entity {1}.", key, entity);
    }

    public static SamlValidationSpecificationFailure unsupportedKey(String key) {
        return new GenericHubProfileValidationSpecification("Unspecified key descriptor usage type: {0} is not supported.", key);
    }

    public static SamlValidationSpecificationFailure invalidRequestID() {
        return new GenericHubProfileValidationSpecification("RequestID must start with a letter or an underscore", new Object[0]);
    }

    public static SamlValidationSpecificationFailure invalidRelayState(String relayState) {
        return new RelayStateValidationSpecification("The RelayState has more than 80 characters: ''{0}''", relayState);
    }

    public static SamlValidationSpecificationFailure relayStateContainsInvalidCharacter(String invalidCharacter, String relayState) {
        return new RelayStateValidationSpecification("The RelayState contains illegal character ''{0}'': ''{1}''", invalidCharacter, relayState);
    }

    public static SamlValidationSpecificationFailure invalidAttributeLanguageInAssertion(String name, String language) {
        return new InvalidAttributeLanguageInAssertion(name, language);
    }

    public static SamlValidationSpecificationFailure invalidFraudAttribute(String message) {
        return new SamlValidationSpecification("Unable to deserialize string into OpenSaml object: {0}", message);
    }

    public static SamlValidationSpecificationWarning invalidAttributeNameFormat(String nameFormat) {
        return new InvalidAttributeNameFormat(nameFormat);
    }

    public static SamlValidationSpecificationFailure mismatchedPersistentIdentifiers() {
        return new GenericHubProfileValidationSpecification("IDP matching dataset and authn statement assertions do not contain matching persistent identifiers", new Object[0]);
    }

    public static SamlValidationSpecificationFailure mismatchedIssuers() {
        return new GenericHubProfileValidationSpecification("IDP matching dataset and authn statement assertions do not contain matching issuers", new Object[0]);
    }
}

