/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.saml.metadata.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import uk.gov.ida.common.shared.security.Certificate;
import uk.gov.ida.saml.core.OpenSamlXmlObjectFactory;

public class KeyDescriptorsUnmarshaller {
    private OpenSamlXmlObjectFactory openSamlXmlObjectFactory;

    public KeyDescriptorsUnmarshaller(OpenSamlXmlObjectFactory openSamlXmlObjectFactory) {
        this.openSamlXmlObjectFactory = openSamlXmlObjectFactory;
    }

    public List<KeyDescriptor> fromCertificates(Collection<Certificate> certificateDtos) {
        ArrayList<KeyDescriptor> keyDescriptors = new ArrayList<KeyDescriptor>();
        for (Certificate certificateDto : certificateDtos) {
            KeyDescriptor keyDescriptor = this.openSamlXmlObjectFactory.createKeyDescriptor(certificateDto.getKeyUse().toString());
            KeyInfo keyInfo = this.openSamlXmlObjectFactory.createKeyInfo(certificateDto.getIssuerId());
            keyDescriptor.setKeyInfo(keyInfo);
            X509Data x509Data = this.openSamlXmlObjectFactory.createX509Data();
            X509Certificate x509Certificate = this.openSamlXmlObjectFactory.createX509Certificate(certificateDto.getCertificate());
            x509Data.getX509Certificates().add(x509Certificate);
            keyInfo.getX509Datas().add(x509Data);
            keyDescriptors.add(keyDescriptor);
        }
        return keyDescriptors;
    }
}

