/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.jerseyclient;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.ida.common.ErrorStatusDto;
import uk.gov.ida.common.ExceptionType;
import uk.gov.ida.exceptions.ApplicationException;

public class JsonResponseProcessor {
    private final ObjectMapper objectMapper;
    private static final Logger LOG = LoggerFactory.getLogger(JsonResponseProcessor.class);

    @Inject
    public JsonResponseProcessor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getJsonEntity(URI uri, GenericType<T> genericType, Class<T> clazz, Response clientResponse) {
        Response successResponse = this.filterErrorResponses(uri, clientResponse);
        try {
            if (clazz != null && clazz == Response.class || genericType != null && genericType.getRawType() == Response.class) {
                throw ApplicationException.createUnauditedException(ExceptionType.INVALID_CLIENTRESPONSE_PARAM, UUID.randomUUID());
            }
            if (clazz == null && genericType == null) {
                Object object = new Object();
                return (T)object;
            }
            T t = this.getEntity(genericType, clazz, successResponse);
            return t;
        }
        finally {
            clientResponse.close();
        }
    }

    private <T> T getEntity(GenericType<T> genericType, Class<T> entityClazz, Response response) {
        try {
            if (response.hasEntity()) {
                if (entityClazz != null) {
                    return (T)response.readEntity(entityClazz);
                }
                if (genericType != null) {
                    return (T)response.readEntity(genericType);
                }
            }
        }
        catch (ProcessingException e) {
            throw ApplicationException.createUnauditedException(ExceptionType.NETWORK_ERROR, UUID.randomUUID(), (Throwable)e);
        }
        throw new IllegalArgumentException("Client response has no entity.");
    }

    private Response filterErrorResponses(URI uri, Response response) {
        switch (response.getStatusInfo().getFamily()) {
            case SERVER_ERROR: {
                throw this.createErrorStatus(response, ExceptionType.REMOTE_SERVER_ERROR, uri);
            }
            case CLIENT_ERROR: {
                throw this.createErrorStatus(response, ExceptionType.CLIENT_ERROR, uri);
            }
        }
        return response;
    }

    private ApplicationException createErrorStatus(Response response, ExceptionType exceptionType, URI uri) {
        String entity = (String)response.readEntity(String.class);
        try {
            return ApplicationException.createExceptionFromErrorStatusDto((ErrorStatusDto)this.objectMapper.readValue(entity, ErrorStatusDto.class), uri);
        }
        catch (JsonParseException | JsonMappingException e) {
            return ApplicationException.createExceptionFromErrorStatusDto(ErrorStatusDto.createUnauditedErrorStatus(UUID.randomUUID(), exceptionType, entity), uri);
        }
        catch (IOException e) {
            LOG.error("Unexpected status code [{}] returned from service using URI: {}. Body: {}", new Object[]{response.getStatus(), uri, entity});
            return ApplicationException.createUnauditedException(exceptionType, UUID.randomUUID(), e, uri);
        }
    }
}

