/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.ida.truststore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.KeyStore;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import uk.gov.ida.truststore.ClientTrustStoreConfiguration;
import uk.gov.ida.truststore.KeyStoreLoader;

@Singleton
public class KeyStoreCache {
    private final Cache<String, KeyStore> trustStoreCache;
    private final KeyStoreLoader keyStoreLoader;

    @Inject
    public KeyStoreCache(KeyStoreLoader keyStoreLoader) {
        this.keyStoreLoader = keyStoreLoader;
        this.trustStoreCache = CacheBuilder.newBuilder().build();
    }

    public KeyStore get(ClientTrustStoreConfiguration configuration) {
        final String trustStorePath = configuration.getPath();
        final String password = configuration.getPassword();
        try {
            return (KeyStore)this.trustStoreCache.get((Object)trustStorePath, (Callable)new Callable<KeyStore>(){

                @Override
                public KeyStore call() throws Exception {
                    return KeyStoreCache.this.keyStoreLoader.load(trustStorePath, password);
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

